/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.fog;

import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.CubicSampler;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.VanillaFogRangeCalculator;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.library.BiomeUtil;
import org.orecruncher.lib.GameUtils;

@OnlyIn(value=Dist.CLIENT)
public class BiomeFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected final FogResult cached = new FogResult();

    public BiomeFogRangeCalculator() {
        super("BiomeFogRangeCalculator");
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableBiomeFog.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull ViewportEvent.RenderFog event) {
        ClientLevel world = GameUtils.getWorld();
        assert (world != null);
        BiomeManager biomemanager = world.m_7062_();
        Vec3 origin = GameUtils.getMC().f_91063_.m_109153_().m_90583_().m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        Vec3 visibilitySurvey = CubicSampler.m_130038_((Vec3)origin, (x, y, z) -> {
            Biome b = (Biome)biomemanager.m_204210_(x, y, z).m_203334_();
            BiomeInfo info = BiomeUtil.getBiomeData(b);
            return new Vec3((double)info.getVisibility(), 0.0, 0.0);
        });
        double visibility = visibilitySurvey.m_7096_();
        double farPlaneDistance = visibility * (double)event.getFarPlaneDistance();
        double farPlaneDistanceScaleBiome = 0.1 * (1.0 - visibility) + 0.75 * visibility;
        this.cached.setScaled((float)farPlaneDistance, (float)farPlaneDistanceScaleBiome);
        return this.cached;
    }
}

