/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.fog;

import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;

@OnlyIn(value=Dist.CLIENT)
public final class FogResult {
    public static final float DEFAULT_PLANE_SCALE = 0.75f;
    private float start;
    private float end;

    public FogResult() {
        this(0.0f, 0.0f);
    }

    public FogResult(float distance, float scale) {
        this.set(distance, scale);
    }

    public FogResult(@Nonnull ViewportEvent.RenderFog event) {
        this.set(event);
    }

    public void setScaled(float distance, float scale) {
        this.start = distance * scale;
        this.end = distance;
    }

    public void set(float start, float end) {
        this.start = start;
        this.end = end;
    }

    public void set(@Nonnull ViewportEvent.RenderFog event) {
        this.setScaled(event.getFarPlaneDistance(), 0.75f);
    }

    public float getStart() {
        return this.start;
    }

    public float getEnd() {
        return this.end;
    }

    public boolean isValid(@Nonnull ViewportEvent.RenderFog event) {
        return this.end > this.start;
    }

    public String toString() {
        return String.format("[start: %f, end: %f]", Float.valueOf(this.start), Float.valueOf(this.end));
    }
}

