/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.fog;

import javax.annotation.Nonnull;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.VanillaFogRangeCalculator;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class WeatherFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final float START_IMPACT = 0.9f;
    protected static final float END_IMPACT = 0.4f;
    protected final FogResult cache = new FogResult();

    public WeatherFogRangeCalculator() {
        super("WeatherFogRangeCalculator");
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableWeatherFog.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull ViewportEvent.RenderFog event) {
        this.cache.set(event);
        float rainStr = WorldUtils.getRainStrength((Level)GameUtils.getWorld(), (float)event.getPartialTick());
        if (rainStr > 0.0f) {
            float startScale = 1.0f - 0.9f * rainStr;
            float endScale = 1.0f - 0.4f * rainStr;
            this.cache.set(this.cache.getStart() * startScale, this.cache.getEnd() * endScale);
        }
        return this.cache;
    }
}

