/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.BedrockFogRangeCalculator;
import org.orecruncher.environs.fog.BiomeFogRangeCalculator;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.HazeFogRangeCalculator;
import org.orecruncher.environs.fog.HolisticFogRangeCalculator;
import org.orecruncher.environs.fog.MorningFogRangeCalculator;
import org.orecruncher.environs.fog.WeatherFogRangeCalculator;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.handlers.HandlerBase;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.math.LoggingTimerEMA;

@OnlyIn(value=Dist.CLIENT)
public class FogHandler
extends HandlerBase {
    protected final LoggingTimerEMA render = new LoggingTimerEMA("Render Fog");
    protected HolisticFogRangeCalculator fogRange = new HolisticFogRangeCalculator();

    public FogHandler() {
        super("Fog Handler");
    }

    public static boolean doFog() {
        return (Boolean)Config.CLIENT.fog.enableFog.get() != false && CommonState.getDimensionInfo().hasFog();
    }

    @Override
    public void process(@Nonnull Player player) {
        if (FogHandler.doFog()) {
            this.fogRange.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fogRenderEvent(ViewportEvent.RenderFog event) {
        if (event.getMode() == FogRenderer.FogMode.FOG_TERRAIN && FogHandler.doFog()) {
            ProfilerFiller profiler = GameUtils.getMC().m_91307_();
            profiler.m_6180_("Environs Fog Render");
            this.render.begin();
            FogType fluidState = event.getCamera().m_167685_();
            if (fluidState == FogType.NONE) {
                FogResult result = this.fogRange.calculate(event);
                RenderSystem.m_157445_((float)result.getStart());
                RenderSystem.m_157443_((float)result.getEnd());
            }
            this.render.end();
            profiler.m_7238_();
        }
    }

    @SubscribeEvent
    public void diagnostics(DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            if (FogHandler.doFog()) {
                event.getLeft().add("Fog Range: " + this.fogRange.toString());
                event.addRenderTimer(this.render);
            } else {
                event.getLeft().add("FOG: IGNORED");
            }
        }
    }

    @Override
    public void onConnect() {
        this.fogRange = new HolisticFogRangeCalculator();
        this.fogRange.add(new BiomeFogRangeCalculator());
        this.fogRange.add(new HazeFogRangeCalculator());
        this.fogRange.add(new MorningFogRangeCalculator());
        this.fogRange.add(new BedrockFogRangeCalculator());
        this.fogRange.add(new WeatherFogRangeCalculator());
    }
}

