/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.environs.Environs;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.handlers.AreaBlockEffects;
import org.orecruncher.environs.handlers.AuroraHandler;
import org.orecruncher.environs.handlers.BiomeSoundEffects;
import org.orecruncher.environs.handlers.CommonStateHandler;
import org.orecruncher.environs.handlers.FogHandler;
import org.orecruncher.environs.handlers.HandlerBase;
import org.orecruncher.environs.handlers.ParticleSystems;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.logging.IModLog;

@Mod.EventBusSubscriber(modid="environs", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Manager {
    private static final IModLog LOGGER = Environs.LOGGER.createChild(Manager.class);
    private static final Manager instance_ = new Manager();
    private static boolean isConnected = false;
    private final ObjectArray<HandlerBase> effectHandlers = new ObjectArray();

    public static Manager instance() {
        return instance_;
    }

    private Manager() {
        this.init();
    }

    private void register(@Nonnull HandlerBase handler) {
        this.effectHandlers.add(handler);
        LOGGER.debug("Registered handler [%s]", handler.getClass().getName());
    }

    private void init() {
        this.register(new CommonStateHandler());
        this.register(new AreaBlockEffects());
        this.register(new BiomeSoundEffects());
        this.register(new ParticleSystems());
        this.register(new AuroraHandler());
        this.register(new FogHandler());
    }

    private void onConnect() {
        for (HandlerBase h : this.effectHandlers) {
            h.connect0();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onDisconnect() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        for (HandlerBase h : this.effectHandlers) {
            h.disconnect0();
        }
    }

    public static void connect() {
        if (isConnected) {
            LOGGER.warn("Attempt to initialize EffectManager when it is already initialized", new Object[0]);
            Manager.disconnect();
        }
        instance_.onConnect();
        isConnected = true;
    }

    public static void disconnect() {
        if (isConnected) {
            instance_.onDisconnect();
            isConnected = false;
        }
    }

    protected static Player getPlayer() {
        return GameUtils.getPlayer();
    }

    protected boolean checkReady(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END || Minecraft.m_91087_().m_91104_()) {
            return false;
        }
        return GameUtils.isInGame();
    }

    public void onTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (!this.checkReady(event)) {
            return;
        }
        ProfilerFiller profiler = GameUtils.getMC().m_91307_();
        profiler.m_6180_("Environs Client Tick");
        long tick = TickCounter.getTickCount();
        for (HandlerBase handler : this.effectHandlers) {
            profiler.m_6180_(handler.getHandlerName());
            long mark = System.nanoTime();
            if (handler.doTick(tick)) {
                handler.process(Manager.getPlayer());
            }
            handler.updateTimer(System.nanoTime() - mark);
            profiler.m_7238_();
        }
        profiler.m_7238_();
    }

    @SubscribeEvent
    public static void diagnosticEvent(@Nonnull DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            Manager.instance().effectHandlers.forEach(h -> event.addTimer(h.getTimer()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (isConnected) {
            instance_.onTick(event);
        }
    }
}

