/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.orecruncher.environs.library.IBiome;
import org.orecruncher.lib.biomes.BiomeUtilities;

@OnlyIn(value=Dist.CLIENT)
public class BiomeAdapter
implements IBiome {
    protected final Biome biome;
    protected final Set<TagKey<Biome>> types;

    public BiomeAdapter(@Nonnull Biome biome) {
        this.biome = biome;
        this.types = BiomeUtilities.getBiomeTypes(this.biome);
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public ResourceLocation getKey() {
        return ForgeRegistries.BIOMES.getKey((Object)this.biome);
    }

    @Override
    public String getName() {
        return BiomeUtilities.getBiomeName(this.biome);
    }

    @Override
    public Set<TagKey<Biome>> getTypes() {
        return this.types;
    }

    @Override
    public Biome.Precipitation getPrecipitationType() {
        return this.biome.m_47530_();
    }

    @Override
    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return this.biome.m_47505_(pos);
    }

    @Override
    public float getTemperature() {
        return this.biome.m_47554_();
    }

    @Override
    public boolean isHighHumidity() {
        return this.biome.m_47533_();
    }

    @Override
    public float getDownfall() {
        return this.biome.m_47548_();
    }

    @Override
    public boolean isFake() {
        return false;
    }
}

