/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.lib.biomes.BiomeUtilities;
import org.orecruncher.lib.scripting.ExecutionContext;

@OnlyIn(value=Dist.CLIENT)
public class BiomeEvaluator {
    private final ExecutionContext context = new ExecutionContext("Biomes");

    public void update(@Nonnull BiomeInfo biome) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        props.put("name", biome.getBiomeName());
        props.put("id", biome.getKey().toString());
        props.put("modid", biome.getKey().m_135827_());
        props.put("isFake", biome.isFake());
        if (biome.isFake()) {
            props.put("temperature", 0);
            props.put("rainfall", 0);
        } else {
            props.put("temperature", Float.valueOf(biome.getTemperature()));
            props.put("rainfall", Float.valueOf(biome.getRainfall()));
        }
        Collection<TagKey<Biome>> types = BiomeUtilities.getBiomeTypes();
        Set<TagKey<Biome>> biomeTypes = biome.getBiomeTypes();
        for (TagKey<Biome> t : types) {
            Object name = t.toString();
            if (StringUtil.m_14408_((String)name)) continue;
            name = ((String)name).length() > 1 ? "is" + ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1).toLowerCase() : "is" + ((String)name).toUpperCase();
            props.put(name, biomeTypes.contains(t));
        }
        this.context.put("biome", props);
    }

    public boolean matches(@Nonnull String conditions) {
        if (conditions.length() == 0) {
            return true;
        }
        Optional<Object> result = this.context.eval(conditions);
        return result.isPresent() && (Boolean)result.get() != false;
    }
}

