/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.mixins;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.biome.Biome;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.handlers.FogHandler;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.library.BiomeUtil;
import org.orecruncher.environs.misc.IMixinBiomeData;
import org.orecruncher.lib.gui.Color;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public class MixinBiome
implements IMixinBiomeData {
    private BiomeInfo environs_biomeInfo;

    @Override
    @Nullable
    public BiomeInfo getInfo() {
        return this.environs_biomeInfo;
    }

    @Override
    public void setInfo(@Nullable BiomeInfo info) {
        this.environs_biomeInfo = info;
    }

    @Inject(method={"getFogColor()I"}, at={@At(value="HEAD")}, cancellable=true)
    public void getFogColor(@Nonnull CallbackInfoReturnable<Integer> cir) {
        BiomeInfo info;
        Color color;
        if (this.doFogColor() && (color = (info = BiomeUtil.getBiomeData((Biome)this)).getFogColor()) != null) {
            cir.setReturnValue((Object)color.rgb());
        }
    }

    private boolean doFogColor() {
        return FogHandler.doFog() && (Boolean)Config.CLIENT.fog.enableBiomeFog.get() != false;
    }
}

