/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.scanner.ScanContext;
import org.orecruncher.lib.random.XorShiftRandom;

@OnlyIn(value=Dist.CLIENT)
public abstract class Scanner {
    protected static final Set<BlockState> BLOCKSTATES_TO_IGNORE = new ReferenceArraySet(3);
    private static final int MAX_BLOCKS_TICK = 6000;
    protected final String name;
    protected final int xRange;
    protected final int yRange;
    protected final int zRange;
    protected final int xSize;
    protected final int ySize;
    protected final int zSize;
    protected final int blocksPerTick;
    protected final int volume;
    protected final ScanContext locus;
    protected final Random random = new XorShiftRandom();
    protected final BlockPos.MutableBlockPos workingPos = new BlockPos.MutableBlockPos();

    public Scanner(@Nonnull ScanContext locus, @Nonnull String name, int range) {
        this(locus, name, range, 0);
    }

    public Scanner(@Nonnull ScanContext locus, @Nonnull String name, int range, int blocksPerTick) {
        this(locus, name, range, range, range, blocksPerTick);
    }

    public Scanner(@Nonnull ScanContext locus, @Nonnull String name, int xRange, int yRange, int zRange) {
        this(locus, name, xRange, yRange, zRange, 0);
    }

    public Scanner(@Nonnull ScanContext locus, @Nonnull String name, int xRange, int yRange, int zRange, int blocksPerTick) {
        this.name = name;
        this.xRange = xRange;
        this.yRange = yRange;
        this.zRange = zRange;
        this.xSize = xRange * 2;
        this.ySize = yRange * 2;
        this.zSize = zRange * 2;
        this.volume = this.xSize * this.ySize * this.zSize;
        this.blocksPerTick = blocksPerTick == 0 ? Math.min(this.volume / 20, 6000) : Math.min(blocksPerTick, 6000);
        this.locus = locus;
    }

    public int getVolume() {
        return this.volume;
    }

    public abstract void blockScan(@Nonnull BlockState var1, @Nonnull BlockPos var2, @Nonnull Random var3);

    protected boolean interestingBlock(BlockState state) {
        return state.m_60767_() != Material.f_76296_;
    }

    public void preScan() {
    }

    public void postScan() {
    }

    public void tick() {
        BlockPos pos;
        this.preScan();
        BlockGetter provider = this.locus.getWorld();
        for (int count = 0; count < this.blocksPerTick && (pos = this.nextPos(this.workingPos, this.random)) != null; ++count) {
            BlockState state = provider.m_8055_(pos);
            if (BLOCKSTATES_TO_IGNORE.contains(state) || !this.interestingBlock(state)) continue;
            this.blockScan(state, pos, this.random);
        }
        this.postScan();
    }

    @Nullable
    protected abstract BlockPos nextPos(@Nonnull BlockPos.MutableBlockPos var1, @Nonnull Random var2);

    static {
        BLOCKSTATES_TO_IGNORE.add(Blocks.f_50626_.m_49966_());
        BLOCKSTATES_TO_IGNORE.add(Blocks.f_50627_.m_49966_());
        BLOCKSTATES_TO_IGNORE.add(Blocks.f_50016_.m_49966_());
    }
}

