/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.shaders.aurora;

import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.shaders.aurora.AuroraFactory;
import org.orecruncher.environs.shaders.aurora.Panel;
import org.orecruncher.lib.math.MathStuff;

@OnlyIn(value=Dist.CLIENT)
public class AuroraBand {
    protected static final float AURORA_SPEED = 0.75f;
    protected static final float AURORA_WAVELENGTH = 18.0f;
    public static final float AURORA_AMPLITUDE = 180.0f;
    protected final Random random;
    protected Panel[] nodes;
    protected float cycle = 0.0f;
    protected int alphaLimit = 128;
    protected int length;
    protected float nodeLength;
    protected float nodeWidth;

    public AuroraBand(Random random, AuroraFactory.AuroraGeometry geo) {
        this.random = random;
        this.preset(geo);
        this.generateBands();
        this.translate(0.0f);
    }

    public int getAlphaLimit() {
        return this.alphaLimit;
    }

    public float getNodeWidth() {
        return this.nodeWidth;
    }

    public int getPanelCount() {
        return this.nodes.length - 1;
    }

    @Nullable
    public Vector3f[] getPanelQuad(int panelNumber) {
        if (panelNumber < 0 || panelNumber >= this.getPanelCount()) {
            return null;
        }
        Vector3f[] nodes = new Vector3f[4];
        Panel panelA = this.nodes[panelNumber];
        Panel panelB = this.nodes[panelNumber + 1];
        nodes[0] = new Vector3f(panelA.tetX, 0.0f, panelA.tetZ);
        nodes[1] = new Vector3f(panelB.tetX, 0.0f, panelB.tetZ);
        nodes[2] = new Vector3f(panelB.tetX, panelB.getModdedY(), panelB.tetZ);
        nodes[3] = new Vector3f(panelA.tetX, panelA.getModdedY(), panelA.tetZ);
        return nodes;
    }

    public void update() {
        float f;
        this.cycle += 0.75f;
        if (f >= 360.0f) {
            this.cycle -= 360.0f;
        }
    }

    public void translate(float partialTick) {
        float c = this.cycle + 0.75f * partialTick;
        for (int i = 0; i < this.nodes.length; ++i) {
            float f = MathStuff.cos(MathStuff.toRadians((float)(i << 3) + c));
            this.nodes[i].translate(f * 3.0f, f * 18.0f);
        }
    }

    protected void preset(AuroraFactory.AuroraGeometry geo) {
        this.length = geo.length;
        this.nodeLength = geo.nodeLength;
        this.nodeWidth = geo.nodeWidth;
        this.alphaLimit = geo.alphaLimit;
    }

    protected void generateBands() {
        this.nodes = this.populate();
        for (int i = 0; i < this.length; ++i) {
            this.nodes[i].setWidth(this.nodeWidth);
        }
    }

    @Nonnull
    protected Panel[] populate() {
        float x;
        float z;
        float subAngleRads;
        float subAngle;
        Panel node;
        int idx;
        float angle;
        Panel[] nodeList = new Panel[this.length];
        float[] angles = new float[this.length];
        int bound = this.length / 2 - 1;
        float angleTotal = 0.0f;
        for (int i = this.length / 8 / 2 - 1; i >= 0; --i) {
            angle = (this.random.nextFloat() - 0.5f) * 8.0f;
            if (MathStuff.abs(angleTotal += angle) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int k = 7; k >= 0; --k) {
                idx = i * 8 + k;
                if (idx == bound) {
                    nodeList[idx] = new Panel(0.0f, 180.0f, 0.0f);
                    angles[idx] = angle;
                    continue;
                }
                node = nodeList[idx + 1];
                subAngle = angles[idx + 1] + angle;
                subAngleRads = MathStuff.toRadians(subAngle);
                z = node.posZ - MathStuff.sin(subAngleRads) * this.nodeLength;
                x = node.posX - MathStuff.cos(subAngleRads) * this.nodeLength;
                nodeList[idx] = new Panel(x, 180.0f, z);
                angles[idx] = subAngle;
            }
        }
        angleTotal = 0.0f;
        for (int j = this.length / 8 / 2; j < this.length / 8; ++j) {
            angle = (this.random.nextFloat() - 0.5f) * 8.0f;
            if (MathStuff.abs(angleTotal += angle) > 180.0f) {
                angle = -angle;
                angleTotal += angle;
            }
            for (int h = 0; h < 8; ++h) {
                idx = j * 8 + h - 1;
                node = nodeList[idx];
                subAngle = angles[idx] + angle;
                subAngleRads = MathStuff.toRadians(subAngle);
                z = node.posZ + MathStuff.sin(subAngleRads) * this.nodeLength;
                x = node.posX + MathStuff.cos(subAngleRads) * this.nodeLength;
                nodeList[idx + 1] = new Panel(x, 180.0f, z);
                angles[idx + 1] = subAngle;
            }
        }
        return nodeList;
    }
}

