/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.shaders.aurora;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.library.DimensionInfo;
import org.orecruncher.environs.shaders.aurora.AuroraBand;
import org.orecruncher.environs.shaders.aurora.AuroraColor;
import org.orecruncher.environs.shaders.aurora.AuroraFactory;
import org.orecruncher.environs.shaders.aurora.AuroraLifeTracker;
import org.orecruncher.environs.shaders.aurora.IAurora;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.gui.Color;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;

@OnlyIn(value=Dist.CLIENT)
public abstract class AuroraBase
implements IAurora {
    protected final Random random;
    protected final AuroraBand band;
    protected final int bandCount;
    protected final float offset;
    protected final AuroraLifeTracker tracker;
    protected final AuroraColor colors;
    protected final Player player;
    protected final DimensionInfo dimInfo;

    public AuroraBase(long seed) {
        this(new XorShiftRandom(seed));
    }

    public AuroraBase(Random rand) {
        this.random = rand;
        this.bandCount = Math.min(this.random.nextInt(3) + 1, (Integer)Config.CLIENT.aurora.maxBands.get());
        this.offset = this.random.nextInt(20) + 20;
        this.colors = AuroraColor.get(this.random);
        AuroraFactory.AuroraGeometry geo = AuroraFactory.AuroraGeometry.get(this.random);
        this.band = new AuroraBand(this.random, geo);
        this.tracker = new AuroraLifeTracker(512, 1);
        this.player = GameUtils.getPlayer();
        this.dimInfo = CommonState.getDimensionInfo();
    }

    @Override
    public boolean isAlive() {
        return this.tracker.isAlive();
    }

    @Override
    public void setFading(boolean flag) {
        this.tracker.setFading(flag);
    }

    @Override
    public boolean isDying() {
        return this.tracker.isFading();
    }

    @Override
    public void update() {
        this.tracker.update();
    }

    @Override
    public boolean isComplete() {
        return !this.isAlive();
    }

    protected float getAlpha() {
        return this.tracker.ageRatio() * (float)this.band.getAlphaLimit() / 255.0f;
    }

    protected double getTranslationX(float partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.player.f_19790_, (double)this.player.m_20185_());
    }

    protected double getTranslationZ(float partialTick) {
        return Mth.m_14139_((double)partialTick, (double)this.player.f_19792_, (double)this.player.m_20189_()) - 150.0;
    }

    protected double getTranslationY(float partialTick) {
        double posY = Mth.m_14139_((double)partialTick, (double)this.player.f_19791_, (double)this.player.m_20186_()) + 64.0;
        double limit = (double)(this.dimInfo.getSkyHeight() + this.dimInfo.getCloudHeight()) / 2.0;
        return MathStuff.clamp(posY, 64.0, limit);
    }

    @Nonnull
    protected Color getBaseColor() {
        return this.colors.baseColor;
    }

    @Nonnull
    protected Color getFadeColor() {
        return this.colors.fadeColor;
    }

    @Nonnull
    protected Color getMiddleColor() {
        return this.colors.middleColor;
    }

    @Override
    public abstract void render(@Nonnull PoseStack var1, float var2);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("bands: ").append(this.bandCount);
        builder.append(", off: ").append(this.offset);
        builder.append(", len: ").append(this.band.length);
        builder.append(", base: ").append(this.getBaseColor().toString());
        builder.append(", fade: ").append(this.getFadeColor().toString());
        builder.append(", alpha: ").append((int)(this.getAlpha() * 255.0f));
        if (!this.tracker.isAlive()) {
            builder.append(", DEAD");
        } else if (this.tracker.isFading()) {
            builder.append(", FADING");
        }
        return builder.toString();
    }
}

