/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.shaders.aurora;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.shaders.ShaderPrograms;
import org.orecruncher.environs.shaders.aurora.AuroraBase;
import org.orecruncher.environs.shaders.aurora.AuroraRenderType;
import org.orecruncher.environs.shaders.aurora.AuroraUtils;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.shaders.ShaderCallContext;

@OnlyIn(value=Dist.CLIENT)
public class AuroraShaderBand
extends AuroraBase {
    private static final float V1 = 0.0f;
    private static final float V2 = 0.5f;
    protected ShaderPrograms program = ShaderPrograms.AURORA;
    protected Consumer<ShaderCallContext> callback = shaderCallContext -> {
        shaderCallContext.set("time", AuroraUtils.getTimeSeconds() * 0.75f);
        shaderCallContext.set("resolution", this.getAuroraWidth(), this.getAuroraHeight());
        shaderCallContext.set("topColor", this.getFadeColor());
        shaderCallContext.set("middleColor", this.getMiddleColor());
        shaderCallContext.set("bottomColor", this.getBaseColor());
        shaderCallContext.set("alpha", this.getAlpha());
    };
    protected final float auroraWidth = (float)this.band.getPanelCount() * this.band.getNodeWidth();
    protected final float panelTexWidth = this.band.getNodeWidth() / this.auroraWidth;

    public AuroraShaderBand(long seed) {
        super(seed);
    }

    @Override
    public void update() {
        super.update();
        this.band.update();
    }

    @Override
    protected float getAlpha() {
        return MathStuff.clamp((float)this.band.getAlphaLimit() / 255.0f * this.tracker.ageRatio() * 2.0f, 0.0f, 1.0f);
    }

    protected float getAuroraWidth() {
        return this.auroraWidth;
    }

    protected float getAuroraHeight() {
        return 180.0f;
    }

    protected void generateBand(@Nonnull VertexConsumer builder, @Nonnull Matrix4f matrix) {
        Vector3f[] quad;
        int i = 0;
        while ((quad = this.band.getPanelQuad(i)) != null) {
            float u1 = (float)i * this.panelTexWidth;
            float u2 = u1 + this.panelTexWidth;
            builder.m_85982_(matrix, quad[0].m_122239_(), quad[0].m_122260_(), quad[0].m_122269_()).m_7421_(u1, 0.0f).m_5752_();
            builder.m_85982_(matrix, quad[1].m_122239_(), quad[1].m_122260_(), quad[1].m_122269_()).m_7421_(u2, 0.0f).m_5752_();
            builder.m_85982_(matrix, quad[2].m_122239_(), quad[2].m_122260_(), quad[2].m_122269_()).m_7421_(u2, 0.5f).m_5752_();
            builder.m_85982_(matrix, quad[3].m_122239_(), quad[3].m_122260_(), quad[3].m_122269_()).m_7421_(u1, 0.5f).m_5752_();
            ++i;
        }
    }

    @Override
    public void render(@Nonnull PoseStack matrixStack, float partialTick) {
        if (this.program == null) {
            return;
        }
        this.band.translate(partialTick);
        double tranY = this.getTranslationY(partialTick);
        double tranX = this.getTranslationX(partialTick);
        double tranZ = this.getTranslationZ(partialTick);
        Vec3 view = GameUtils.getMC().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        RenderType type = AuroraRenderType.QUAD;
        MultiBufferSource.BufferSource buffer = GameUtils.getMC().m_91269_().m_110104_();
        ShaderPrograms.MANAGER.useShader(this.program, this.callback);
        try {
            for (int b = 0; b < this.bandCount; ++b) {
                VertexConsumer builder = buffer.m_6299_(type);
                matrixStack.m_85836_();
                matrixStack.m_85837_(tranX, tranY, tranZ + (double)(this.offset * (float)b));
                this.generateBand(builder, matrixStack.m_85850_().m_85861_());
                matrixStack.m_85849_();
                RenderSystem.m_69465_();
                buffer.m_109912_(type);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.program = null;
        }
        ShaderPrograms.MANAGER.releaseShader();
        matrixStack.m_85849_();
    }

    @Override
    public String toString() {
        return "<SHADER> " + super.toString();
    }
}

