/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.shaders.aurora;

import java.time.Instant;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;

@OnlyIn(value=Dist.CLIENT)
public class AuroraUtils {
    public static final int PLAYER_FIXED_Y_OFFSET = 64;
    public static final int PLAYER_FIXED_Z_OFFSET = 150;
    public static final int AURORA_PEAK_AGE = 512;
    public static final int AURORA_AGE_RATE = 1;

    private AuroraUtils() {
    }

    public static int getChunkRenderDistance() {
        return (Integer)GameUtils.getGameSettings().m_231984_().m_231551_();
    }

    public static float getTimeSeconds() {
        return ((float)TickCounter.getTickCount() + GameUtils.getMC().m_91296_()) / 20.0f;
    }

    public static boolean dimensionHasAuroras() {
        return CommonState.getDimensionInfo().hasAuroras();
    }

    public static long getSeed() {
        long seed = Instant.now().toEpochMilli() / 1440000L * 311L;
        return seed + (long)CommonState.getClock().getDay();
    }
}

