/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import com.google.common.collect.AbstractIterator;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public final class BlockPosUtil {
    private BlockPosUtil() {
    }

    public static BlockPos getNonOffsetPos(@Nonnull Entity entity) {
        return entity.m_20183_().m_7949_();
    }

    public static BlockPos.MutableBlockPos setPos(@Nonnull BlockPos.MutableBlockPos pos, @Nonnull Vec3 vec) {
        return pos.m_122169_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public static boolean canFormCuboid(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return p1.m_123341_() != p2.m_123341_() && p1.m_123343_() != p2.m_123343_() && p1.m_123342_() != p2.m_123342_();
    }

    public static BlockPos createMinPoint(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return new BlockPos(Math.min(p1.m_123341_(), p2.m_123341_()), Math.min(p1.m_123342_(), p2.m_123342_()), Math.min(p1.m_123343_(), p2.m_123343_()));
    }

    public static BlockPos createMaxPoint(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return new BlockPos(Math.max(p1.m_123341_(), p2.m_123341_()), Math.max(p1.m_123342_(), p2.m_123342_()), Math.max(p1.m_123343_(), p2.m_123343_()));
    }

    public static boolean contains(@Nonnull BlockPos test, @Nonnull BlockPos min, @Nonnull BlockPos max) {
        return test.m_123341_() >= min.m_123341_() && test.m_123341_() <= max.m_123341_() && test.m_123342_() >= min.m_123342_() && test.m_123342_() <= max.m_123342_() && test.m_123343_() >= min.m_123343_() && test.m_123343_() <= max.m_123343_();
    }

    public static boolean notContains(@Nonnull BlockPos test, @Nonnull BlockPos min, @Nonnull BlockPos max) {
        return test.m_123341_() < min.m_123341_() || test.m_123341_() > max.m_123341_() || test.m_123342_() < min.m_123342_() || test.m_123342_() > max.m_123342_() || test.m_123343_() < min.m_123343_() || test.m_123343_() > max.m_123343_();
    }

    public static Iterable<BlockPos.MutableBlockPos> getAllInBoxMutable(@Nonnull BlockPos from, @Nonnull BlockPos to) {
        final BlockPos minPos = BlockPosUtil.createMinPoint(from, to);
        final BlockPos maxPos = BlockPosUtil.createMaxPoint(from, to);
        return () -> new AbstractIterator<BlockPos.MutableBlockPos>(){
            private final int minX;
            private final int minY;
            private final int minZ;
            private final int maxX;
            private final int maxY;
            private final int maxZ;
            private BlockPos.MutableBlockPos currentPos;
            private int currentX;
            private int currentY;
            private int currentZ;
            {
                this.minX = minPos.m_123341_();
                this.minY = minPos.m_123342_();
                this.minZ = minPos.m_123343_();
                this.maxX = maxPos.m_123341_();
                this.maxY = maxPos.m_123342_();
                this.maxZ = maxPos.m_123343_();
                this.currentX = this.minX;
                this.currentY = this.minY;
                this.currentZ = this.minZ;
            }

            private boolean isEndFinished() {
                return this.currentX == this.maxX && this.currentY == this.maxY && this.currentZ == this.maxZ;
            }

            protected BlockPos.MutableBlockPos computeNext() {
                if (this.currentPos == null) {
                    this.currentPos = new BlockPos.MutableBlockPos(this.minX, this.minY, this.minZ);
                    return this.currentPos;
                }
                if (this.isEndFinished()) {
                    return (BlockPos.MutableBlockPos)this.endOfData();
                }
                if (this.currentX < this.maxX) {
                    ++this.currentX;
                } else if (this.currentZ < this.maxZ) {
                    this.currentX = this.minX;
                    ++this.currentZ;
                } else if (this.currentY < this.maxY) {
                    this.currentX = this.minX;
                    this.currentZ = this.minZ;
                    ++this.currentY;
                }
                this.currentPos.m_122178_(this.currentX, this.currentY, this.currentZ);
                return this.currentPos;
            }
        };
    }
}

