/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.compat.ModEnvironment;
import org.orecruncher.lib.reflection.BooleanField;

public final class WorldUtils {
    private static final BooleanField<ClientLevel.ClientLevelData> flatWorld;
    public static final float COLD_THRESHOLD = 0.2f;
    public static final float SNOW_THRESHOLD = 0.15f;
    private static final ITemperatureHandler TEMP;
    private static final IWeatherStrength RAIN_STRENGTH;
    private static final IWeatherStrength THUNDER_STRENGTH;
    private static final IWeatherAspect RAIN_OCCURING;
    private static final IWeatherAspect THUNDER_OCCURING;

    private WorldUtils() {
    }

    @Nonnull
    public static BlockPos getTopSolidOrLiquidBlock(@Nonnull LevelReader world, @Nonnull BlockPos pos) {
        return new BlockPos(pos.m_123341_(), world.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
    }

    public static float getTemperatureAt(@Nonnull Level world, @Nonnull BlockPos pos) {
        return TEMP.getTemp(world, pos);
    }

    public static boolean isColdTemperature(float temp) {
        return temp < 0.2f;
    }

    public static boolean isSnowTemperature(float temp) {
        return temp < 0.15f;
    }

    public static boolean isSolid(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction dir) {
        BlockState state = world.m_8055_(pos);
        return Block.m_49918_((VoxelShape)state.m_60742_(world, pos, CollisionContext.m_82749_()), (Direction)dir);
    }

    public static boolean isTopSolid(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return WorldUtils.isSolid(world, pos, Direction.UP);
    }

    public static boolean isBlockSolid(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60815_();
    }

    public static boolean isAirBlock(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return WorldUtils.isAirBlock(world.m_8055_(pos));
    }

    public static boolean isAirBlock(@Nonnull BlockState state) {
        return state.m_60767_() == Material.f_76296_;
    }

    public static Biome.Precipitation getCurrentPrecipitationAt(@Nonnull LevelReader world, @Nonnull BlockPos pos) {
        if (!(world instanceof Level) || !WorldUtils.isRaining((Level)world)) {
            return Biome.Precipitation.NONE;
        }
        Biome biome = (Biome)world.m_204166_(pos).m_203334_();
        if (biome.m_47530_() == Biome.Precipitation.NONE) {
            return Biome.Precipitation.NONE;
        }
        BlockPos p = WorldUtils.getPrecipitationHeight(world, pos);
        if (p.m_123342_() > pos.m_123342_()) {
            return Biome.Precipitation.NONE;
        }
        float temp = WorldUtils.getTemperatureAt((Level)world, pos);
        return WorldUtils.isSnowTemperature(temp) ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN;
    }

    public static float getRainStrength(@Nonnull Level world, float partialTicks) {
        return RAIN_STRENGTH.getStrength(world, partialTicks);
    }

    public static float getThunderStrength(@Nonnull Level world, float partialTicks) {
        return THUNDER_STRENGTH.getStrength(world, partialTicks);
    }

    public static boolean isRaining(@Nonnull Level world) {
        return RAIN_OCCURING.isOccuring(world);
    }

    public static boolean isThundering(@Nonnull Level world) {
        return THUNDER_OCCURING.isOccuring(world);
    }

    @Nonnull
    public static BlockPos getPrecipitationHeight(@Nonnull LevelReader world, @Nonnull BlockPos pos) {
        return world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos);
    }

    public static boolean hasVoidParticles(@Nonnull Level world) {
        return world.m_6042_().f_223549_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isSuperFlat(@Nonnull Level world) {
        LevelData info = world.m_6106_();
        return info instanceof ClientLevel.ClientLevelData && (Boolean)flatWorld.get((ClientLevel.ClientLevelData)info) != false;
    }

    static {
        ITemperatureHandler TEMP1;
        flatWorld = new BooleanField<ClientLevel.ClientLevelData>(ClientLevel.ClientLevelData.class, false, "flatWorld", "isFlat");
        if (ModEnvironment.SereneSeasons.isLoaded()) {
            try {
                Class<?> clazz = Class.forName("sereneseasons.season.SeasonHooks");
                Method method = clazz.getMethod("getBiomeTemperature", Level.class, Biome.class, BlockPos.class);
                TEMP1 = (world, pos) -> {
                    try {
                        return ((Float)method.invoke(null, world, world.m_204166_(pos), pos)).floatValue();
                    }
                    catch (Throwable t) {
                        return ((Biome)world.m_204166_(pos).m_203334_()).m_47505_(pos);
                    }
                };
                Lib.LOGGER.info("Hooked SereneSeasons getBiomeTemperature()", new Object[0]);
            }
            catch (Throwable t) {
                Lib.LOGGER.warn("Unable to hook SereneSeasons getBiomeTemperature()!", new Object[0]);
                TEMP1 = (world, pos) -> ((Biome)world.m_204166_(pos).m_203334_()).m_47505_(pos);
            }
        } else {
            TEMP1 = (world, pos) -> ((Biome)world.m_204166_(pos).m_203334_()).m_47505_(pos);
        }
        TEMP = TEMP1;
        RAIN_STRENGTH = Level::m_46722_;
        RAIN_OCCURING = Level::m_46471_;
        THUNDER_STRENGTH = Level::m_46661_;
        THUNDER_OCCURING = Level::m_46470_;
    }

    private static interface ITemperatureHandler {
        public float getTemp(@Nonnull Level var1, @Nonnull BlockPos var2);
    }

    private static interface IWeatherStrength {
        public float getStrength(@Nonnull Level var1, float var2);
    }

    private static interface IWeatherAspect {
        public boolean isOccuring(@Nonnull Level var1);
    }
}

