/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.biomes;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.IReverseTag;
import org.orecruncher.environs.Environs;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Localization;
import org.orecruncher.lib.gui.Color;

@OnlyIn(value=Dist.CLIENT)
public class BiomeUtilities {
    private static final Color NO_COLOR = new Color(1.0f, 1.0f, 1.0f);

    private BiomeUtilities() {
    }

    @Nonnull
    public static String getBiomeName(@Nonnull Biome biome) {
        Biome forgeBiome;
        ResourceLocation loc = Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
        if (loc == null && (forgeBiome = BiomeUtilities.getClientBiome(biome)) != null) {
            loc = ForgeRegistries.BIOMES.getKey((Object)forgeBiome);
        }
        if (loc == null) {
            return "UNKNOWN";
        }
        String fmt = String.format("biome.%s.%s", loc.m_135827_(), loc.m_135815_());
        return Localization.load(fmt);
    }

    @Nonnull
    public static Collection<TagKey<Biome>> getBiomeTypes() {
        return Minecraft.m_91087_().f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_203613_().collect(Collectors.toSet());
    }

    @Nonnull
    public static Color getColorForLiquid(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        Biome biome;
        FluidState fluidState = world.m_6425_(pos);
        if (fluidState.m_76178_()) {
            return NO_COLOR;
        }
        Fluid fluid = fluidState.m_76152_();
        if (fluid.m_205067_(FluidTags.f_13131_) && (biome = BiomeUtilities.getClientBiome(pos)) != null) {
            return new Color(biome.m_47560_());
        }
        return new Color(IClientFluidTypeExtensions.of((FluidType)fluid.getFluidType()).getTintColor());
    }

    @Nonnull
    public static Set<TagKey<Biome>> getBiomeTypes(@Nonnull Biome biome) {
        try {
            ResourceLocation boop = ForgeRegistries.BIOMES.getKey((Object)biome);
            if (boop != null) {
                return ((IReverseTag)ForgeRegistries.BIOMES.tags().getReverseTag((Object)biome).get()).getTagKeys().collect(Collectors.toSet());
            }
        }
        catch (Throwable t) {
            String name = biome.toString();
            Environs.LOGGER.warn("Unable to get biome type data for biome '%s'", name);
        }
        return ImmutableSet.of();
    }

    @Nullable
    public static Biome getClientBiome(@Nonnull BlockPos pos) {
        ClientLevel world = GameUtils.getWorld();
        if (world == null) {
            return (Biome)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_).m_6246_(Biomes.f_48173_);
        }
        Biome biome = (Biome)world.m_204166_(pos).m_203334_();
        return BiomeUtilities.getClientBiome(biome);
    }

    @Nullable
    public static Biome getClientBiome(@Nonnull Biome biome) {
        ClientLevel world = GameUtils.getWorld();
        if (world == null) {
            return (Biome)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_).m_6246_(Biomes.f_48173_);
        }
        ResourceLocation loc = world.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
        if (loc == null) {
            return (Biome)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_).m_6246_(Biomes.f_48173_);
        }
        Biome result = (Biome)ForgeRegistries.BIOMES.getValue(loc);
        if (result == null) {
            return (Biome)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_).m_6246_(Biomes.f_48173_);
        }
        return result;
    }
}

