/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.blockstate;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.blockstate.BlockStateParser;
import org.orecruncher.lib.blockstate.BlockStateProperties;

public final class BlockStateMatcher {
    public static final BlockStateMatcher AIR = new BlockStateMatcher(Blocks.f_50016_.m_49966_());
    @Nonnull
    protected final Block block;
    @Nonnull
    private final BlockStateProperties props;

    BlockStateMatcher(@Nonnull BlockState state) {
        this(state.m_60734_(), (Map<Property<?>, Comparable<?>>)state.m_61148_());
    }

    BlockStateMatcher(@Nonnull Block block) {
        this.block = block;
        this.props = BlockStateProperties.NONE;
    }

    BlockStateMatcher(@Nonnull Block block, @Nonnull Map<Property<?>, Comparable<?>> props) {
        this.block = block;
        this.props = props.size() > 0 ? new BlockStateProperties(props) : BlockStateProperties.NONE;
    }

    @Nonnull
    public static BlockStateMatcher asGeneric(@Nonnull BlockState state) {
        return new BlockStateMatcher(state.m_60734_());
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull BlockState state) {
        return new BlockStateMatcher(state);
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull Block block) {
        return new BlockStateMatcher(block);
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull String blockId) {
        return BlockStateParser.parseBlockState(blockId).map(BlockStateMatcher::create).orElse(AIR);
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull BlockStateParser.ParseResult result) {
        Block block = result.getBlock();
        BlockState defaultState = block.m_49966_();
        StateDefinition container = block.m_49965_();
        if (container.m_61056_().size() == 1) {
            return new BlockStateMatcher(defaultState);
        }
        if (!result.hasProperties()) {
            return new BlockStateMatcher(block);
        }
        Map<String, String> properties = result.getProperties();
        IdentityHashMap props = new IdentityHashMap(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String s = entry.getKey();
            Property prop = container.m_61081_(s);
            if (prop != null) {
                Optional optional = prop.m_6215_(entry.getValue());
                if (optional.isPresent()) {
                    props.put(prop, (Comparable)optional.get());
                    continue;
                }
                String allowed = BlockStateMatcher.getAllowedValues(block, s);
                Lib.LOGGER.warn("Property value '%s' for property '%s' not found for block '%s'", entry.getValue(), s, result.getBlockName());
                Lib.LOGGER.warn("Allowed values: %s", allowed);
                continue;
            }
            Lib.LOGGER.warn("Property %s not found for block %s", s, result.getBlockName());
        }
        return new BlockStateMatcher(defaultState.m_60734_(), props);
    }

    @Nonnull
    private static <T extends Comparable<T>> String getAllowedValues(@Nonnull Block block, @Nonnull String propName) {
        Property prop = block.m_49965_().m_61081_(propName);
        if (prop != null) {
            return prop.m_6908_().stream().map(arg_0 -> ((Property)prop).m_6940_(arg_0)).collect(Collectors.joining(","));
        }
        return "Invalid property " + propName;
    }

    public boolean isEmpty() {
        return this.block == Blocks.f_50016_ || this.block == Blocks.f_50627_ || this.block == Blocks.f_50626_;
    }

    @Nonnull
    public Block getBlock() {
        return this.block;
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockStateMatcher) {
            BlockStateMatcher m = (BlockStateMatcher)obj;
            return this.block == m.block && m.props.matches(this.props);
        }
        return false;
    }

    @Nonnull
    public String toString() {
        return ForgeRegistries.BLOCKS.getKey((Object)this.block) + this.props.getFormattedProperties();
    }
}

