/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringListBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.config.ConfigProperty;

@OnlyIn(value=Dist.CLIENT)
public abstract class ClothAPIFactory
implements BiFunction<Minecraft, Screen, Screen> {
    private final Component title;
    private final Runnable save;
    private final ResourceLocation background;

    public ClothAPIFactory(@Nonnull Component title, @Nonnull Runnable save) {
        this(title, save, null);
    }

    public ClothAPIFactory(@Nonnull Component title, @Nonnull Runnable save, @Nullable ResourceLocation background) {
        this.title = title;
        this.save = save;
        this.background = background;
    }

    @Override
    public Screen apply(@Nonnull Minecraft minecraft, @Nonnull Screen screen) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle(this.title).setSavingRunnable(this.save);
        if (this.background != null) {
            builder.setDefaultBackgroundTexture(this.background);
        }
        this.generate(builder);
        return builder.build();
    }

    protected abstract void generate(@Nonnull ConfigBuilder var1);

    public static ConfigCategory createRootCategory(@Nonnull ConfigBuilder builder) {
        return ClothAPIFactory.createCategory(builder, "dontcare");
    }

    public static ConfigCategory createCategory(@Nonnull ConfigBuilder builder, @Nonnull String translationKey) {
        return builder.getOrCreateCategory(ClothAPIFactory.transformText(translationKey, ChatFormatting.GOLD));
    }

    public static SubCategoryBuilder createSubCategory(@Nonnull ConfigEntryBuilder entryBuilder, @Nonnull String translationKey, boolean expanded) {
        return ClothAPIFactory.createSubCategory(entryBuilder, translationKey, null, expanded);
    }

    public static SubCategoryBuilder createSubCategory(@Nonnull ConfigEntryBuilder entryBuilder, @Nonnull String translationKey, @Nullable ChatFormatting color, boolean expanded) {
        Component label = ClothAPIFactory.transformText(translationKey, color);
        ArrayList<Object> toolTip = new ArrayList<Object>();
        toolTip.add(label);
        List lines = GameUtils.getMC().f_91062_.m_92865_().m_92414_((FormattedText)Component.m_237115_((String)(translationKey + ".tooltip")), 300, Style.f_131099_);
        for (FormattedText l : lines) {
            toolTip.add(Component.m_237113_((String)l.getString()));
        }
        return entryBuilder.startSubCategory(label).setTooltip(toolTip.toArray(new Component[0])).setExpanded(expanded);
    }

    public static StringListEntry createString(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.ConfigValue<String> value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        MutableComponent name = property.getConfigName();
        StringFieldBuilder result = builder.entryBuilder().startStrField((Component)name, (String)value.get()).setTooltip(property.getTooltip()).setDefaultValue((String)value.get()).setSaveConsumer(arg_0 -> value.set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static BooleanListEntry createBoolean(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.BooleanValue value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        MutableComponent name = property.getConfigName();
        BooleanToggleBuilder result = builder.entryBuilder().startBooleanToggle((Component)name, ((Boolean)value.get()).booleanValue()).setTooltip(property.getTooltip()).setDefaultValue(((Boolean)value.get()).booleanValue()).setYesNoTextSupplier(CommonComponents::m_130666_).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)value).set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static IntegerListEntry createInteger(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.IntValue value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        MutableComponent name = property.getConfigName();
        int min = (Integer)property.getMinValue();
        int max = (Integer)property.getMaxValue();
        IntFieldBuilder result = builder.entryBuilder().startIntField((Component)name, ((Integer)value.get()).intValue()).setTooltip(property.getTooltip()).setDefaultValue(((Integer)value.get()).intValue()).setMin(min).setMax(max).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)value).set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static StringListListEntry createStringList(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.ConfigValue<List<? extends String>> value, @Nullable Function<String, Optional<Component>> validator) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        MutableComponent name = property.getConfigName();
        List list = ((List)value.get()).stream().map(Object::toString).collect(Collectors.toList());
        ArrayList defaults = new ArrayList(list);
        StringListBuilder result = builder.entryBuilder().startStrList((Component)name, list).setTooltip(property.getTooltip()).setDefaultValue(defaults).setSaveConsumer(arg_0 -> value.set(arg_0));
        if (validator != null) {
            result.setCellErrorSupplier(validator);
        }
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static <T extends Enum<T>> EnumListEntry<T> createEnumList(@Nonnull ConfigBuilder builder, @Nonnull Class<T> clazz, @Nonnull ForgeConfigSpec.EnumValue<T> value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        MutableComponent name = property.getConfigName();
        EnumSelectorBuilder result = builder.entryBuilder().startEnumSelector((Component)name, clazz, (Enum)value.get()).setTooltip(property.getTooltip()).setDefaultValue((Enum)value.get()).setSaveConsumer(arg_0 -> value.set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    public static IntegerSliderEntry createIntegerSlider(@Nonnull ConfigBuilder builder, @Nonnull ForgeConfigSpec.IntValue value) {
        ConfigProperty property = ConfigProperty.getPropertyInfo(value);
        MutableComponent name = property.getConfigName();
        int min = (Integer)property.getMinValue();
        int max = (Integer)property.getMaxValue();
        IntSliderBuilder result = builder.entryBuilder().startIntSlider((Component)name, ((Integer)value.get()).intValue(), min, max).setTooltip(property.getTooltip()).setDefaultValue(((Integer)value.get()).intValue()).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)value).set(arg_0));
        if (property.getNeedsWorldRestart()) {
            result.requireRestart();
        }
        return result.build();
    }

    private static Component transformText(@Nonnull String key, @Nullable ChatFormatting color) {
        MutableComponent result = Component.m_237115_((String)key);
        if (color != null) {
            String text = color + Component.m_237115_((String)key).getString();
            result = Component.m_237113_((String)text);
        }
        return result;
    }
}

