/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.config;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.orecruncher.lib.gui.GuiHelpers;
import org.orecruncher.lib.reflection.ObjectField;

@OnlyIn(value=Dist.CLIENT)
public final class ConfigProperty {
    public static final int TOOLTIP_WIDTH = 300;
    private static final ObjectField<ForgeConfigSpec.ConfigValue, ForgeConfigSpec> specAccessor = new ObjectField<ForgeConfigSpec.ConfigValue, ForgeConfigSpec>(ForgeConfigSpec.ConfigValue.class, () -> null, "spec");
    private static final ObjectField<Object, Object> minAccessor = new ObjectField("net.minecraftforge.common.ForgeConfigSpec$Range", () -> null, "min");
    private static final ObjectField<Object, Object> maxAccessor = new ObjectField("net.minecraftforge.common.ForgeConfigSpec$Range", () -> null, "max");
    private final ForgeConfigSpec.ValueSpec valueSpec;
    private final String name;
    private Component[] toolTip;

    private ConfigProperty(@Nonnull ForgeConfigSpec.ConfigValue<?> configEntry) {
        this(specAccessor.get(configEntry), configEntry);
    }

    private ConfigProperty(@Nonnull ForgeConfigSpec spec, @Nonnull ForgeConfigSpec.ConfigValue<?> configEntry) {
        List path = configEntry.getPath();
        this.valueSpec = (ForgeConfigSpec.ValueSpec)spec.get(path);
        this.name = (String)path.get(path.size() - 1);
    }

    public String getTranslationKey() {
        return this.valueSpec.getTranslationKey();
    }

    @Nonnull
    public MutableComponent getConfigName() {
        String key = this.getTranslationKey();
        if (StringUtil.m_14408_((String)key)) {
            return Component.m_237113_((String)this.name);
        }
        return Component.m_237115_((String)key);
    }

    @Nullable
    public String getComment() {
        return this.valueSpec.getComment();
    }

    @Nullable
    public Component[] getTooltip() {
        if (this.toolTip == null) {
            ForgeConfigSpec.Range range;
            ArrayList<Object> result = new ArrayList<Object>();
            String key = this.getTranslationKey();
            if (StringUtil.m_14408_((String)key)) {
                key = this.getComment();
                if (StringUtil.m_14408_((String)key)) {
                    return null;
                }
                result.add(Component.m_237113_((String)key));
            } else {
                MutableComponent title = Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)key).getString()));
                result.add(title);
                result.addAll(GuiHelpers.getTrimmedTextCollection(key + ".tooltip", 300, new ChatFormatting[0]));
            }
            Object theDefault = this.getDefault();
            if (theDefault != null) {
                String text = theDefault.toString();
                text = text.compareToIgnoreCase("true") == 0 ? CommonComponents.f_130653_.getString() : (text.compareToIgnoreCase("false") == 0 ? CommonComponents.f_130654_.getString() : GuiHelpers.getTrimmedText(text, 300, new ChatFormatting[0]).getString());
                text = Component.m_237110_((String)"dsurround.text.format.default", (Object[])new Object[]{text}).getString();
                result.add(Component.m_237113_((String)text));
            }
            if ((range = this.valueSpec.getRange()) != null) {
                result.add(Component.m_237113_((String)(ChatFormatting.GREEN + "[ " + range.toString() + " ]")));
            }
            if (this.getNeedsWorldRestart()) {
                result.add(Component.m_237115_((String)"dsurround.text.tooltip.restartRequired"));
            }
            this.toolTip = result.toArray(new Component[0]);
        }
        return this.toolTip;
    }

    public boolean getNeedsWorldRestart() {
        return this.valueSpec.needsWorldRestart();
    }

    public <T> T getDefault() {
        return (T)this.valueSpec.getDefault();
    }

    public <T> T getMinValue() {
        return (T)minAccessor.get(this.valueSpec.getRange());
    }

    public <T> T getMaxValue() {
        return (T)maxAccessor.get(this.valueSpec.getRange());
    }

    @Nonnull
    public static ConfigProperty getPropertyInfo(@Nonnull ForgeConfigSpec.ConfigValue<?> configEntry) {
        return new ConfigProperty(configEntry);
    }
}

