/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.fml;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.collections.ObjectArray;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientLoginChecks {
    private static final ObjectArray<ICallbackHandler> handlers = new ObjectArray();

    public static void register(@Nonnull ICallbackHandler handler) {
        handlers.add(handler);
    }

    @SubscribeEvent
    public static void onLogin(@Nonnull ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        if (player != null) {
            Lib.LOGGER.info("Player login: %s", event.getPlayer().m_7755_().getString());
            for (ICallbackHandler callback : handlers) {
                Component msg = callback.onClientLogin(event.getPlayer());
                if (msg == null) continue;
                event.getPlayer().m_213846_(msg);
            }
        }
    }

    @FunctionalInterface
    public static interface ICallbackHandler {
        @Nullable
        public Component onClientLogin(@Nonnull LocalPlayer var1);
    }
}

