/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.gui;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiHelpers {
    private static final String ELLIPSES = "...";

    public static Collection<Component> getTrimmedTextCollection(@Nonnull String key, int width, ChatFormatting ... formatting) {
        Style style = GuiHelpers.prefixHelper(formatting);
        return GameUtils.getMC().f_91062_.m_92865_().m_92414_((FormattedText)Component.m_237115_((String)key), width, style).stream().map(e -> Component.m_237113_((String)e.getString())).collect(Collectors.toList());
    }

    public static Component getTrimmedText(@Nonnull String key, int width, ChatFormatting ... formatting) {
        Style style = GuiHelpers.prefixHelper(formatting);
        MutableComponent text = Component.m_237115_((String)key);
        Font fr = GameUtils.getMC().f_91062_;
        StringSplitter cm = fr.m_92865_();
        if (fr.m_92852_((FormattedText)text) > width) {
            int ellipsesWidth = fr.m_92895_(ELLIPSES);
            int trueWidth = width - ellipsesWidth;
            FormattedText str = cm.m_92389_((FormattedText)text, trueWidth, style);
            return Component.m_237113_((String)(str.getString() + ELLIPSES));
        }
        FormattedText str = cm.m_92389_((FormattedText)text, width, style);
        return Component.m_237113_((String)str.getString());
    }

    private static Style prefixHelper(@Nullable ChatFormatting[] formatting) {
        Style style = formatting != null && formatting.length > 0 ? Style.f_131099_.m_131152_(formatting) : Style.f_131099_;
        return style;
    }
}

