/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.math;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockRayTrace {
    private static final double NUDGE = -1.0E-7;
    final BlockGetter world;
    final ClipContext.Block blockMode;
    final ClipContext.Fluid fluidMode;
    final CollisionContext selectionCtx;
    Vec3 start;
    Vec3 end;

    public BlockRayTrace(@Nonnull BlockGetter world, @Nonnull ClipContext.Block bm, @Nonnull ClipContext.Fluid fm) {
        this(world, Vec3.f_82478_, Vec3.f_82478_, bm, fm);
    }

    public BlockRayTrace(@Nonnull BlockGetter world, @Nonnull Vec3 start, @Nonnull Vec3 end, @Nonnull ClipContext.Block bm, @Nonnull ClipContext.Fluid fm) {
        this.world = world;
        this.start = start;
        this.end = end;
        this.blockMode = bm;
        this.fluidMode = fm;
        this.selectionCtx = CollisionContext.m_82749_();
    }

    @Nonnull
    public BlockHitResult trace() {
        return this.traceLoop();
    }

    @Nonnull
    public BlockHitResult trace(@Nonnull Vec3 start, @Nonnull Vec3 end) {
        this.start = start;
        this.end = end;
        return this.traceLoop();
    }

    @Nonnull
    private BlockHitResult traceLoop() {
        int posZ;
        int posY;
        if (this.start.equals((Object)this.end)) {
            return this.miss();
        }
        double lerpX = Mth.m_14139_((double)-1.0E-7, (double)this.start.f_82479_, (double)this.end.f_82479_);
        double lerpY = Mth.m_14139_((double)-1.0E-7, (double)this.start.f_82480_, (double)this.end.f_82480_);
        double lerpZ = Mth.m_14139_((double)-1.0E-7, (double)this.start.f_82481_, (double)this.end.f_82481_);
        int posX = Mth.m_14107_((double)lerpX);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(posX, posY = Mth.m_14107_((double)lerpY), posZ = Mth.m_14107_((double)lerpZ));
        BlockHitResult traceResult = this.hitCheck((BlockPos)mutablePos);
        if (traceResult == null) {
            double xLerp = Mth.m_14139_((double)-1.0E-7, (double)this.end.f_82479_, (double)this.start.f_82479_);
            double yLerp = Mth.m_14139_((double)-1.0E-7, (double)this.end.f_82480_, (double)this.start.f_82480_);
            double zLerp = Mth.m_14139_((double)-1.0E-7, (double)this.end.f_82481_, (double)this.start.f_82481_);
            double lenX = xLerp - lerpX;
            double lenY = yLerp - lerpY;
            double lenZ = zLerp - lerpZ;
            int dirX = Mth.m_14205_((double)lenX);
            int dirY = Mth.m_14205_((double)lenY);
            int dirZ = Mth.m_14205_((double)lenZ);
            double deltaX = dirX == 0 ? Double.MAX_VALUE : (double)dirX / lenX;
            double deltaY = dirY == 0 ? Double.MAX_VALUE : (double)dirY / lenY;
            double deltaZ = dirZ == 0 ? Double.MAX_VALUE : (double)dirZ / lenZ;
            double X = deltaX * (dirX > 0 ? 1.0 - Mth.m_14185_((double)lerpX) : Mth.m_14185_((double)lerpX));
            double Y = deltaY * (dirY > 0 ? 1.0 - Mth.m_14185_((double)lerpY) : Mth.m_14185_((double)lerpY));
            double Z = deltaZ * (dirZ > 0 ? 1.0 - Mth.m_14185_((double)lerpZ) : Mth.m_14185_((double)lerpZ));
            do {
                if (X > 1.0 && Y > 1.0 && Z > 1.0) {
                    return this.miss();
                }
                if (X < Y) {
                    if (X < Z) {
                        posX += dirX;
                        X += deltaX;
                        continue;
                    }
                    posZ += dirZ;
                    Z += deltaZ;
                    continue;
                }
                if (Y < Z) {
                    posY += dirY;
                    Y += deltaY;
                    continue;
                }
                posZ += dirZ;
                Z += deltaZ;
            } while ((traceResult = this.hitCheck((BlockPos)mutablePos.m_122178_(posX, posY, posZ))) == null);
        }
        return traceResult;
    }

    @Nonnull
    private BlockHitResult miss() {
        Vec3 directionVec = this.start.m_82546_(this.end);
        return BlockHitResult.m_82426_((Vec3)this.end, (Direction)Direction.m_122366_((double)directionVec.f_82479_, (double)directionVec.f_82480_, (double)directionVec.f_82481_), (BlockPos)new BlockPos(this.end));
    }

    @Nullable
    private BlockHitResult hitCheck(@Nonnull BlockPos pos) {
        double fluidDistance;
        VoxelShape voxelFluidShape;
        VoxelShape voxelShape;
        BlockHitResult traceResult = null;
        BlockState state = this.world.m_8055_(pos);
        if (!state.m_60795_() && !(voxelShape = this.blockMode.m_7544_(state, this.world, pos, this.selectionCtx)).m_83281_()) {
            traceResult = this.world.m_45558_(this.start, this.end, pos, voxelShape, state);
        }
        BlockHitResult fluidTraceResult = null;
        FluidState fluidState = state.m_60819_();
        if (!fluidState.m_76178_() && this.fluidMode.m_45731_(fluidState) && !(voxelFluidShape = state.m_60808_(this.world, pos)).m_83281_()) {
            fluidTraceResult = voxelFluidShape.m_83220_(this.start, this.end, pos);
        }
        if (traceResult == fluidTraceResult) {
            return null;
        }
        if (fluidTraceResult == null) {
            return traceResult;
        }
        if (traceResult == null) {
            return fluidTraceResult;
        }
        double blockDistance = this.start.m_82557_(traceResult.m_82450_());
        return blockDistance <= (fluidDistance = this.start.m_82557_(fluidTraceResult.m_82450_())) ? traceResult : fluidTraceResult;
    }
}

