/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.math;

import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public final class MathStuff {
    public static final double PHI;
    public static final float PHI_F;
    public static final double ANGLE;
    public static final float ANGLE_F;
    public static final float PI_F = (float)Math.PI;
    public static final float E_F = (float)Math.E;
    private static final int SIN_BITS = 16;
    private static final int SIN_MASK = 65535;
    private static final int SIN_COUNT = 65536;
    private static final float RAD_FULL = (float)Math.PI * 2;
    private static final float RAD_TO_INDEX = 10430.378f;
    private static final float DEG_FULL = 360.0f;
    private static final float DEG_TO_INDEX = 182.04445f;
    private static final float COS_TO_SIN = 1.5707964f;
    private static final float[] SIN_TABLE;
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM;
    private static final float ATAN2_DIM_MINUS_1;
    private static final float[] ATAN2_TABLE;
    private static final float RAD_TO_DEG = 57.29578f;
    private static final float DEG_TO_RAD = (float)Math.PI / 180;

    private MathStuff() {
    }

    public static float sin(float rad) {
        return SIN_TABLE[(int)(rad * 10430.378f) & 0xFFFF];
    }

    public static float cos(float rad) {
        return SIN_TABLE[(int)((rad + 1.5707964f) * 10430.378f) & 0xFFFF];
    }

    public static float tan(float rad) {
        return MathStuff.sin(rad) / MathStuff.cos(rad);
    }

    public static double sin(double rad) {
        float tmp = (float)rad;
        return SIN_TABLE[(int)(tmp * 10430.378f) & 0xFFFF];
    }

    public static double cos(double rad) {
        float tmp = (float)rad;
        return SIN_TABLE[(int)((tmp + 1.5707964f) * 10430.378f) & 0xFFFF];
    }

    public static double tan(double rad) {
        return MathStuff.tan((float)rad);
    }

    public static float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                x = -x;
                y = -y;
                mul = 1.0f;
            } else {
                x = -x;
                mul = -1.0f;
            }
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = ATAN2_DIM_MINUS_1 / Math.max(x, y);
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (ATAN2_TABLE[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static double atan2(double y, double x) {
        float tmp1 = (float)y;
        float tmp2 = (float)x;
        return MathStuff.atan2(tmp1, tmp2);
    }

    public static float toRadians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float radians) {
        return radians * 57.29578f;
    }

    public static float wrapDegrees(float value) {
        return Mth.m_14177_((float)value);
    }

    public static double wrapDegrees(double value) {
        return Mth.m_14175_((double)value);
    }

    public static float abs(float val) {
        return Math.abs(val);
    }

    public static double abs(double val) {
        return Math.abs(val);
    }

    public static long abs(long val) {
        return Math.abs(val);
    }

    public static int abs(int val) {
        return Math.abs(val);
    }

    public static float sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    public static double sqrt(double value) {
        return Math.sqrt(value);
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static double log(double value) {
        return value < 0.03 ? Math.log(value) : 6.0 * (value - 1.0) / (value + 1.0 + 4.0 * Math.sqrt(value));
    }

    public static double pow(double a, double b) {
        long tmp = Double.doubleToRawLongBits(a);
        long tmp2 = (long)(b * (double)(tmp - 4606921280493453312L)) + 4606921280493453312L;
        return Double.longBitsToDouble(tmp2);
    }

    public static double exp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static float clamp(float num, float min, float max) {
        return num <= min ? min : MathStuff.min(num, max);
    }

    public static double clamp(double num, double min, double max) {
        return num <= min ? min : MathStuff.min(num, max);
    }

    public static int clamp(int num, int min, int max) {
        return num <= min ? min : MathStuff.min(num, max);
    }

    public static int min(int v1, int v2) {
        return v1 <= v2 ? v1 : v2;
    }

    public static int max(int v1, int v2) {
        return v1 <= v2 ? v2 : v1;
    }

    public static float min(float v1, float v2) {
        return v1 <= v2 ? v1 : v2;
    }

    public static float max(float v1, float v2) {
        return v1 <= v2 ? v2 : v1;
    }

    public static double min(double v1, double v2) {
        return v1 <= v2 ? v1 : v2;
    }

    public static double max(double v1, double v2) {
        return v1 <= v2 ? v2 : v1;
    }

    public static float clamp1(float num) {
        return num <= 0.0f ? 0.0f : MathStuff.min(num, 1.0f);
    }

    public static double clamp1(double num) {
        return num <= 0.0 ? 0.0 : MathStuff.min(num, 1.0);
    }

    @Nonnull
    public static Vec2 rotateScale(@Nonnull Vec2 coord, float radians, float scale) {
        float f = MathStuff.cos(radians);
        float f1 = MathStuff.sin(radians);
        float d0 = coord.f_82470_ * f + coord.f_82471_ * f1;
        float d1 = coord.f_82471_ * f - coord.f_82470_ * f1;
        return new Vec2(d0 * scale, d1 * scale);
    }

    @Nonnull
    public static Vec2 rotate(@Nonnull Vec2 coord, float radians) {
        return MathStuff.rotateScale(coord, radians, 1.0f);
    }

    @Nonnull
    public static Vec3 getVectorForRotation(float pitch, float yaw) {
        float f = MathStuff.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float f1 = MathStuff.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = -MathStuff.cos(-pitch * ((float)Math.PI / 180));
        float f3 = MathStuff.sin(-pitch * ((float)Math.PI / 180));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    @Nonnull
    public static Vec3 reflection(@Nonnull Vec3 vector, @Nonnull Vec3 surfaceNormal) {
        double dot2 = vector.m_82526_(surfaceNormal) * 2.0;
        double x = vector.f_82479_ - dot2 * surfaceNormal.f_82479_;
        double y = vector.f_82480_ - dot2 * surfaceNormal.f_82480_;
        double z = vector.f_82481_ - dot2 * surfaceNormal.f_82481_;
        return new Vec3(x, y, z);
    }

    public static boolean isValid(@Nonnull Vec3 vec) {
        return !Double.isNaN(vec.f_82479_) && !Double.isNaN(vec.f_82480_) && !Double.isNaN(vec.f_82481_);
    }

    @Nonnull
    public static Vec3 addScaled(@Nonnull Vec3 base, @Nonnull Vec3 addened, double scale) {
        return base.m_82520_(addened.m_7096_() * scale, addened.m_7098_() * scale, addened.m_7094_() * scale);
    }

    @Nonnull
    public static Vec3 normalize(@Nonnull Vec3 origin, @Nonnull Vec3 target) {
        return target.m_82546_(origin).m_82541_();
    }

    static {
        int i;
        PHI = 0.5 + Math.sqrt(5.0) / 2.0;
        PHI_F = (float)PHI;
        ANGLE = PHI * Math.PI * 2.0;
        ANGLE_F = (float)ANGLE;
        SIN_TABLE = new float[65536];
        ATAN2_DIM = (int)Math.sqrt(16384.0);
        ATAN2_DIM_MINUS_1 = ATAN2_DIM - 1;
        ATAN2_TABLE = new float[16384];
        double twoPi = Math.PI * 2;
        for (i = 0; i < 65536; ++i) {
            MathStuff.SIN_TABLE[i] = (float)Math.sin(((double)i + 0.5) / 65536.0 * (Math.PI * 2));
        }
        for (i = 0; i < 360; i += 90) {
            MathStuff.SIN_TABLE[(int)((float)i * 182.04445f) & 0xFFFF] = (float)Math.sin((double)i * Math.PI / 180.0);
        }
        for (i = 0; i < ATAN2_DIM; ++i) {
            for (int j = 0; j < ATAN2_DIM; ++j) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                MathStuff.ATAN2_TABLE[j * MathStuff.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
            }
        }
    }
}

