/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.particles;

import java.lang.ref.WeakReference;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.math.TimerEMA;
import org.orecruncher.lib.particles.IParticleCollection;
import org.orecruncher.lib.particles.IParticleMote;
import org.orecruncher.lib.particles.ParticleCollection;

@OnlyIn(value=Dist.CLIENT)
final class ParticleCollectionHelper
implements IParticleCollection {
    protected final String name;
    protected final ParticleCollection.ICollectionFactory factory;
    protected final ParticleRenderType renderType;
    protected WeakReference<ParticleCollection> collection;

    public ParticleCollectionHelper(@Nonnull String name, @Nonnull ParticleRenderType renderType) {
        this(name, ParticleCollection.FACTORY, renderType);
    }

    public ParticleCollectionHelper(@Nonnull String name, @Nonnull ParticleCollection.ICollectionFactory factory, @Nonnull ParticleRenderType renderType) {
        this.name = name;
        this.renderType = renderType;
        this.factory = factory;
    }

    @Override
    @Nonnull
    public String name() {
        return this.name;
    }

    @Nonnull
    private Optional<ParticleCollection> get() {
        ParticleCollection pc;
        ParticleCollection particleCollection = pc = this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null;
        if (pc == null || !pc.m_107276_()) {
            pc = this.factory.create(this.name, (Level)GameUtils.getWorld(), this.renderType);
            this.collection = new WeakReference<ParticleCollection>(pc);
            GameUtils.getMC().f_91061_.m_107344_((Particle)pc);
        }
        return Optional.of(pc);
    }

    @Override
    public void add(@Nonnull IParticleMote mote) {
        this.get().ifPresent(pc -> {
            if (pc.canFit()) {
                pc.addParticle(mote);
            }
        });
    }

    @Override
    public boolean canFit() {
        Optional<ParticleCollection> pc = this.get();
        return pc.isPresent() && pc.get().canFit();
    }

    void clear() {
        this.resolve().ifPresent(Particle::m_107274_);
        this.collection = null;
    }

    @Nonnull
    Optional<TimerEMA> getRenderTimer() {
        return this.resolve().map(ParticleCollection::getRenderTimer);
    }

    @Nonnull
    Optional<TimerEMA> getTickTimer() {
        return this.resolve().map(ParticleCollection::getTickTimer);
    }

    @Nonnull
    private Optional<ParticleCollection> resolve() {
        return Optional.ofNullable(this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null);
    }

    public String toString() {
        ParticleCollection pc;
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append('=');
        ParticleCollection particleCollection = pc = this.collection != null ? (ParticleCollection)((Object)this.collection.get()) : null;
        if (pc == null) {
            builder.append("No Collection");
        } else if (!pc.m_107276_()) {
            builder.append("Expired");
        } else if (pc.shouldDie()) {
            builder.append("Should Die");
        } else {
            builder.append(pc.size());
        }
        return builder.toString();
    }
}

