/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.resource;

import java.io.InputStream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.orecruncher.lib.resource.ResourceAccessorBase;

@OnlyIn(value=Dist.CLIENT)
final class ResourceAccessorPack
extends ResourceAccessorBase {
    private final PackResources pack;
    private final ResourceLocation actual;

    public ResourceAccessorPack(@Nonnull ResourceLocation location, @Nonnull PackResources pack, @Nonnull ResourceLocation actual) {
        super(location);
        this.pack = pack;
        this.actual = actual;
    }

    @Override
    protected byte[] getAsset() {
        byte[] byArray;
        block8: {
            InputStream stream = this.pack.m_8031_(PackType.CLIENT_RESOURCES, this.actual);
            try {
                byArray = IOUtils.toByteArray((InputStream)stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.logError(t);
                    return null;
                }
            }
            stream.close();
        }
        return byArray;
    }

    @Override
    public String toString() {
        return String.format("%s (%s = %s)", super.toString(), this.pack.m_8017_(), this.actual.toString());
    }
}

