/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.resource.IResourceAccessor;
import org.orecruncher.lib.resource.Manifest;

@OnlyIn(value=Dist.CLIENT)
public final class ResourceUtils {
    private static final String MANIFEST_FILE = "manifest.json";
    private static Collection<String> cachedNamespaces = null;

    private ResourceUtils() {
    }

    public static void clearCache() {
        cachedNamespaces = null;
    }

    public static Collection<IResourceAccessor> findConfigs(@Nonnull String modId, @Nonnull File root, @Nonnull String config) {
        String specialConfigFolder = modId + "_configs";
        String resourceContainer = specialConfigFolder + "/%s";
        String parentModConfigs = modId + "/configs";
        HashMap<ResourceLocation, IResourceAccessor> locations = new HashMap<ResourceLocation, IResourceAccessor>();
        Collection<Pack> packs = ForgeUtils.getEnabledResourcePacks();
        Collection<String> namespaceList = ResourceUtils.discoverNamespaces(resourceContainer);
        for (Pack pack : packs) {
            PackResources rp = pack.m_10445_();
            Set namespaces = rp.m_5698_(PackType.CLIENT_RESOURCES);
            for (String mod : namespaceList) {
                String container;
                ResourceLocation location;
                IResourceAccessor accessor;
                if (!namespaces.contains(mod) || !(accessor = IResourceAccessor.createPackResource(rp, location = new ResourceLocation(mod, config), new ResourceLocation(mod, container = String.format(resourceContainer, config)))).exists()) continue;
                ResourceLocation loc = new ResourceLocation(mod, config);
                locations.put(loc, accessor);
            }
        }
        for (String mod : namespaceList) {
            ResourceLocation location = new ResourceLocation(mod, config);
            IResourceAccessor accessor = IResourceAccessor.createExternalResource(root, location);
            if (accessor.exists()) {
                locations.put(location, accessor);
                continue;
            }
            accessor = IResourceAccessor.createJarResource(parentModConfigs, location);
            if (!accessor.exists()) continue;
            locations.put(location, accessor);
        }
        return locations.values();
    }

    public static Collection<IResourceAccessor> findSounds() {
        ArrayList<IResourceAccessor> results = new ArrayList<IResourceAccessor>();
        Collection<Pack> packs = ForgeUtils.getEnabledResourcePacks();
        for (Pack pack : packs) {
            PackResources rp = pack.m_10445_();
            Set embeddedNamespaces = rp.m_5698_(PackType.CLIENT_RESOURCES);
            for (String ns : embeddedNamespaces) {
                ResourceLocation location = new ResourceLocation(ns, "sounds.json");
                IResourceAccessor accessor = IResourceAccessor.createPackResource(pack.m_10445_(), location, location);
                if (!accessor.exists()) continue;
                results.add(accessor);
            }
        }
        return results;
    }

    private static Collection<String> discoverNamespaces(@Nonnull String resourceContainer) {
        if (cachedNamespaces != null) {
            return cachedNamespaces;
        }
        String container = String.format(resourceContainer, MANIFEST_FILE);
        ArrayList<String> namespaces = new ArrayList<String>(ForgeUtils.getModIdList());
        Collection<Pack> packs = ForgeUtils.getEnabledResourcePacks();
        for (Pack pack : packs) {
            PackResources rp = pack.m_10445_();
            Set embeddedNamespaces = rp.m_5698_(PackType.CLIENT_RESOURCES);
            for (String ns : embeddedNamespaces) {
                Manifest manifest;
                if (namespaces.contains(ns)) continue;
                ResourceLocation location = new ResourceLocation(ns, container);
                IResourceAccessor accessor = IResourceAccessor.createPackResource(pack.m_10445_(), location, location);
                if (!accessor.exists() || (manifest = accessor.as(Manifest.class)) == null) continue;
                Lib.LOGGER.info("Resource Pack namespace detected: %s", manifest.getName());
                namespaces.add(ns);
            }
        }
        cachedNamespaces = namespaces;
        return cachedNamespaces;
    }

    @Nullable
    public static String readResource(@Nonnull ResourceLocation location) {
        return ResourceUtils.readResource("", location);
    }

    @Nullable
    public static String readResource(@Nonnull String root, @Nonnull ResourceLocation location) {
        IResourceAccessor accessor = IResourceAccessor.createJarResource(root, location);
        return accessor.asString();
    }
}

