/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.scripting.sets;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.biomes.BiomeUtilities;
import org.orecruncher.lib.scripting.VariableSet;
import org.orecruncher.lib.scripting.sets.IBiomeVariables;
import org.orecruncher.lib.scripting.sets.LazyVariable;

@OnlyIn(value=Dist.CLIENT)
public class BiomeVariables
extends VariableSet<IBiomeVariables>
implements IBiomeVariables {
    private Biome biome;
    private final LazyVariable<Set<TagKey<Biome>>> biomeTraits = new LazyVariable<Set>(() -> BuiltinRegistries.f_123865_.m_203613_().collect(Collectors.toSet()));
    private final LazyVariable<Set<String>> biomeTraitNames = new LazyVariable<Set>(() -> this.biomeTraits.get().stream().map(TagKey::toString).collect(Collectors.toSet()));
    private final LazyVariable<String> traits = new LazyVariable<String>(() -> String.join((CharSequence)" ", (Iterable<? extends CharSequence>)this.biomeTraitNames.get()));
    private final LazyVariable<String> name = new LazyVariable<String>(() -> BiomeUtilities.getBiomeName(this.biome));
    private final LazyVariable<String> modid = new LazyVariable<String>(() -> BuiltinRegistries.f_123865_.m_7981_((Object)this.biome).m_135827_());
    private final LazyVariable<String> id = new LazyVariable<String>(() -> BuiltinRegistries.f_123865_.m_7981_((Object)this.biome).toString());
    private final LazyVariable<String> category = new LazyVariable<String>(() -> BuiltinRegistries.f_123865_.m_206081_((ResourceKey)BuiltinRegistries.f_123865_.m_7854_((Object)this.biome).get()).toString());
    private final LazyVariable<String> rainType = new LazyVariable<String>(() -> this.biome.m_47530_().m_47731_());

    public BiomeVariables() {
        super("biome");
        this.setBiome((Biome)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_).m_6246_(Biomes.f_48202_));
    }

    public void setBiome(@Nonnull Biome biome) {
        if (this.biome != biome) {
            this.update();
            this.biome = biome;
        }
    }

    @Override
    @Nonnull
    public IBiomeVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        Biome newBiome = null;
        newBiome = GameUtils.isInGame() ? BiomeUtilities.getClientBiome(GameUtils.getPlayer().m_20183_()) : (Biome)((RegistryAccess.Frozen)RegistryAccess.f_123049_.get()).m_175515_(Registry.f_122885_).m_6246_(Biomes.f_48202_);
        if (newBiome != this.biome) {
            this.biome = newBiome;
            this.name.reset();
            this.modid.reset();
            this.id.reset();
            this.category.reset();
            this.rainType.reset();
            this.traits.reset();
            this.biomeTraits.reset();
            this.biomeTraitNames.reset();
        }
    }

    @Override
    public String getModId() {
        return this.modid.get();
    }

    @Override
    public String getId() {
        return this.id.get();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name.get();
    }

    @Override
    public float getRainfall() {
        return this.biome.m_47548_();
    }

    @Override
    public float getTemperature() {
        return this.biome.m_47554_();
    }

    @Override
    public String getCategory() {
        return this.category.get();
    }

    @Override
    public String getRainType() {
        return this.rainType.get();
    }

    @Override
    public String getTraits() {
        return this.traits.get();
    }

    @Override
    public boolean is(@Nonnull String traitName) {
        return this.biomeTraitNames.get().contains(traitName.toUpperCase());
    }
}

