/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.shaders;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.shaders.IShaderResourceProvider;
import org.orecruncher.lib.shaders.ShaderCallContext;
import org.orecruncher.lib.shaders.ShaderProgram;

@OnlyIn(value=Dist.CLIENT)
public final class ShaderManager<T extends Enum<T>> {
    private final Class<T> clazz;
    private final EnumMap<T, ShaderProgram> programs;
    private final Supplier<Boolean> supportCheck;

    public ShaderManager(@Nonnull Class<T> clazz) {
        this(clazz, () -> true);
    }

    public ShaderManager(@Nonnull Class<T> clazz, @Nonnull Supplier<Boolean> supportCheck) {
        Objects.requireNonNull(clazz);
        this.clazz = clazz;
        this.programs = new EnumMap(clazz);
        this.supportCheck = supportCheck;
        for (Enum shader : (Enum[])clazz.getEnumConstants()) {
            String shaderName = shader.name();
            Objects.requireNonNull(((IShaderResourceProvider)((Object)shader)).getVertex(), String.format("%s provided null for vertex shader", shaderName));
            Objects.requireNonNull(((IShaderResourceProvider)((Object)shader)).getFragment(), String.format("%s provided null for fragment shader", shaderName));
        }
    }

    public boolean supported() {
        return this.supportCheck.get();
    }

    public void useShader(@Nonnull T shader, @Nullable Consumer<ShaderCallContext> callback) {
        Objects.requireNonNull(shader);
        if (!this.supported()) {
            return;
        }
        ShaderProgram program = this.programs.get(shader);
        if (program == null) {
            return;
        }
        int programId = program.m_108943_();
        ProgramManager.m_85578_((int)programId);
        if (callback != null) {
            callback.accept(new ShaderCallContext(program));
        }
    }

    public void useShader(@Nonnull T shader) {
        this.useShader(shader, null);
    }

    public void releaseShader() {
        if (this.supported()) {
            ProgramManager.m_85578_((int)0);
        }
    }

    public void initShaders() {
        if (!this.supported()) {
            return;
        }
        if (GameUtils.getMC().m_91098_() instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)GameUtils.getMC().m_91098_()).m_7217_((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
                this.programs.values().forEach(ProgramManager::m_166621_);
                this.programs.clear();
                this.loadShaders(manager);
            }));
        }
    }

    private void loadShaders(@Nonnull ResourceManager manager) {
        for (Enum shader : (Enum[])this.clazz.getEnumConstants()) {
            ShaderProgram program = this.createProgram(manager, shader);
            if (program == null) continue;
            this.programs.put(shader, this.createProgram(manager, shader));
        }
    }

    @Nullable
    private ShaderProgram createProgram(@Nonnull ResourceManager manager, @Nonnull T shader) {
        try {
            Program vert = ShaderManager.createShader(manager, ((IShaderResourceProvider)shader).getVertex(), Program.Type.VERTEX);
            if (vert == null) {
                return null;
            }
            Program frag = ShaderManager.createShader(manager, ((IShaderResourceProvider)shader).getFragment(), Program.Type.FRAGMENT);
            if (frag == null) {
                return null;
            }
            int programId = ProgramManager.m_85577_();
            ShaderProgram program = new ShaderProgram(((IShaderResourceProvider)shader).getShaderName(), programId, vert, frag);
            ProgramManager.m_166623_((Shader)program);
            program.setUniforms(((IShaderResourceProvider)shader).getUniforms());
            return program;
        }
        catch (IOException ex) {
            Lib.LOGGER.error(ex, "Failed to load program %s", ((IShaderResourceProvider)shader).getShaderName());
            return null;
        }
    }

    private static Program createShader(final @Nonnull ResourceManager manager, final @Nonnull ResourceLocation loc, final @Nonnull Program.Type shaderType) throws IOException {
        Optional stream = manager.m_213713_(loc);
        if (stream.isEmpty()) {
            return null;
        }
        try (BufferedInputStream is = new BufferedInputStream(((Resource)stream.get()).m_215507_());){
            Program program = Program.m_166604_((Program.Type)shaderType, (String)loc.toString(), (InputStream)is, (String)shaderType.name().toLowerCase(Locale.ROOT), (GlslPreprocessor)new GlslPreprocessor(){
                private final Set<String> importedPaths = Sets.newHashSet();

                public String m_142138_(boolean p_173374_, String p_173375_) {
                    String s = "environs:shaders/" + loc.m_135815_() + shaderType.m_85569_();
                    String s1 = FileUtil.m_179922_((String)s);
                    p_173375_ = FileUtil.m_179924_((String)((p_173374_ ? s1 : "environs:shaders/") + p_173375_));
                    if (!this.importedPaths.add(p_173375_)) {
                        return null;
                    }
                    ResourceLocation resourcelocation1 = new ResourceLocation(p_173375_);
                    try {
                        String s2;
                        Resource resource1 = (Resource)manager.m_213713_(resourcelocation1).get();
                        try {
                            s2 = IOUtils.toString((InputStream)resource1.m_215507_(), (Charset)StandardCharsets.UTF_8);
                        }
                        finally {
                            if (resource1 != null) {
                                // empty if block
                            }
                        }
                        return s2;
                    }
                    catch (IOException ioexception) {
                        return "#error " + ioexception.getMessage();
                    }
                }
            });
            return program;
        }
    }
}

