/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.shaders;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Effect;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.Lib;

@OnlyIn(value=Dist.CLIENT)
final class ShaderProgram
implements Effect {
    private final String name;
    private final int program;
    private final Program vert;
    private final Program frag;
    private final Object2IntOpenHashMap<String> uniforms = new Object2IntOpenHashMap();

    ShaderProgram(@Nonnull String name, int program, @Nonnull Program vert, @Nonnull Program frag) {
        this.name = name;
        this.program = program;
        this.vert = vert;
        this.frag = frag;
        this.uniforms.defaultReturnValue(-1);
    }

    public int m_108943_() {
        return this.program;
    }

    void setUniforms(@Nonnull Collection<String> uniforms) {
        for (String u : uniforms) {
            int id = GlStateManager.m_84345_((int)this.program, (CharSequence)u);
            if (id < 0) {
                Lib.LOGGER.warn("Cannot locate uniform '%s' for shader '%s'", u, this.name);
            }
            this.uniforms.put((Object)u, id);
        }
    }

    int getUniform(@Nonnull String uniform) {
        return this.uniforms.getInt((Object)uniform);
    }

    public void m_108957_() {
    }

    @Nonnull
    public Program m_108962_() {
        return this.vert;
    }

    @Nonnull
    public Program m_108964_() {
        return this.frag;
    }

    public void m_142662_() {
        RenderSystem.m_187554_();
        this.vert.m_166610_((Shader)this);
        this.frag.m_166610_((Shader)this);
    }

    public String toString() {
        return String.format("%s [%d]", this.name, this.program);
    }
}

