/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.effects.FactoryHandler;
import org.orecruncher.mobeffects.footsteps.FootprintStyle;
import org.orecruncher.mobeffects.footsteps.Generator;
import org.orecruncher.mobeffects.library.FootstepLibrary;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.api.effects.IEntityEffectManager;

@OnlyIn(value=Dist.CLIENT)
public class EntityFootprintEffect
extends AbstractEntityEffect {
    private static final ResourceLocation NAME = new ResourceLocation("mobeffects", "footprint");
    public static final FactoryHandler FACTORY = new FactoryHandler(NAME, entity -> entity instanceof Player ? new PlayerFootprintEffect() : new EntityFootprintEffect());
    protected Generator generator;

    public EntityFootprintEffect() {
        super(NAME);
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectManager state) {
        super.intitialize(state);
        this.generator = FootstepLibrary.createGenerator(this.getEntity());
    }

    @Override
    public void update() {
        this.generator.generateFootsteps(this.getEntity());
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.generator.getPedometer();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class PlayerFootprintEffect
    extends EntityFootprintEffect {
        protected FootprintStyle lastStyle;

        private PlayerFootprintEffect() {
        }

        @Override
        public void intitialize(@Nonnull IEntityEffectManager state) {
            super.intitialize(state);
            this.lastStyle = (FootprintStyle)((Object)Config.CLIENT.footsteps.playerFootprintStyle.get());
        }

        @Override
        public void update() {
            FootprintStyle currentStyle = (FootprintStyle)((Object)Config.CLIENT.footsteps.playerFootprintStyle.get());
            if (this.lastStyle != currentStyle) {
                this.generator = FootstepLibrary.createGenerator(this.getEntity());
                this.lastStyle = currentStyle;
            }
            super.update();
        }
    }
}

