/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.effects.FactoryHandler;
import org.orecruncher.mobeffects.library.ItemData;
import org.orecruncher.mobeffects.library.ItemLibrary;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.api.effects.IEntityEffectManager;

@OnlyIn(value=Dist.CLIENT)
public class PlayerToolbarEffect
extends AbstractEntityEffect {
    private static final ResourceLocation NAME = new ResourceLocation("mobeffects", "toolbar");
    public static final FactoryHandler FACTORY = new FactoryHandler(NAME, entity -> new PlayerToolbarEffect());
    protected MainHandTracker mainHand;
    protected HandTracker offHand;

    public PlayerToolbarEffect() {
        super(NAME);
    }

    @Override
    public void intitialize(@Nonnull IEntityEffectManager manager) {
        super.intitialize(manager);
        Player player = (Player)this.getEntity();
        this.mainHand = new MainHandTracker(manager, player);
        this.offHand = new HandTracker(manager, player);
    }

    @Override
    public void update() {
        Player player = (Player)this.getEntity();
        this.mainHand.update(player);
        this.offHand.update(player);
    }

    protected static class MainHandTracker
    extends HandTracker {
        protected int lastSlot;

        public MainHandTracker(@Nonnull IEntityEffectManager manager, @Nonnull Player player) {
            super(manager, player, InteractionHand.MAIN_HAND);
            this.lastSlot = player.m_150109_().f_35977_;
        }

        @Override
        protected boolean triggerNewEquipSound(@Nonnull Player player) {
            return this.lastSlot != player.m_150109_().f_35977_ || super.triggerNewEquipSound(player);
        }

        @Override
        public void update(@Nonnull Player player) {
            super.update(player);
            this.lastSlot = player.m_150109_().f_35977_;
        }
    }

    protected static class HandTracker {
        protected final IEntityEffectManager manager;
        protected final InteractionHand hand;
        protected Item lastHeld;

        protected HandTracker(@Nonnull IEntityEffectManager manager, @Nonnull Player player) {
            this(manager, player, InteractionHand.OFF_HAND);
        }

        protected HandTracker(@Nonnull IEntityEffectManager manager, @Nonnull Player player, @Nonnull InteractionHand hand) {
            this.manager = manager;
            this.hand = hand;
            this.lastHeld = this.getItemForHand(player, hand);
        }

        protected Item getItemForHand(Player player, InteractionHand hand) {
            ItemStack stack = player.m_21120_(hand);
            return stack.m_41720_();
        }

        protected boolean triggerNewEquipSound(@Nonnull Player player) {
            Item heldItem = this.getItemForHand(player, this.hand);
            return heldItem != this.lastHeld;
        }

        public void update(@Nonnull Player player) {
            if (this.triggerNewEquipSound(player)) {
                ItemStack currentStack = player.m_21120_(this.hand);
                if (!currentStack.m_41619_()) {
                    ItemData data = ItemLibrary.getItemData(currentStack);
                    if (this.manager.isActivePlayer((LivingEntity)player)) {
                        data.playEquipSound();
                    } else {
                        data.playEquipSound(player.m_20183_());
                    }
                }
                this.lastHeld = currentStack.m_41720_();
            }
        }
    }
}

