/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.effects.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.particles.AgeableMote;
import org.orecruncher.mobeffects.footsteps.FootprintStyle;

@OnlyIn(value=Dist.CLIENT)
public class FootprintMote
extends AgeableMote {
    private static final float TEXEL_WIDTH = 0.125f;
    private static final float TEXEL_PRINT_WIDTH = 0.0625f;
    private static final float WIDTH = 0.125f;
    private static final float LENGTH = 0.25f;
    private static final Vec2 FIRST_POINT = new Vec2(-0.125f, 0.25f);
    private static final Vec2 SECOND_POINT = new Vec2(0.125f, 0.25f);
    private static final Vec2 THIRD_POINT = new Vec2(0.125f, -0.25f);
    private static final Vec2 FOURTH_POINT = new Vec2(-0.125f, -0.25f);
    private static float zFighter = 0.0f;
    protected final boolean isSnowLayer;
    protected final BlockPos downPos;
    protected final float texU1;
    protected final float texU2;
    protected final float texV1;
    protected final float texV2;
    protected final float scale;
    protected final Vec2 firstPoint;
    protected final Vec2 secondPoint;
    protected final Vec2 thirdPoint;
    protected final Vec2 fourthPoint;

    public FootprintMote(@Nonnull FootprintStyle style, @Nonnull BlockGetter world, double x, double y, double z, float rotation, float scale, boolean isRight) {
        super(world, x, y, z);
        BlockState state;
        float f;
        this.maxAge = 200;
        zFighter += 1.0f;
        if (f > 20.0f) {
            zFighter = 1.0f;
        }
        this.isSnowLayer = (state = world.m_8055_((BlockPos)this.position)).m_60734_() == Blocks.f_50125_;
        this.posY += (double)(zFighter * 0.001f);
        float fraction = (float)(y - (double)((int)y));
        this.downPos = this.isSnowLayer || fraction <= 0.0625f ? new BlockPos(this.posX, this.posY, this.posZ).m_7495_() : this.position.m_7949_();
        float u1 = (float)style.ordinal() * 0.125f + 0.00390625f;
        if (isRight) {
            u1 += 0.0625f;
        }
        this.texU1 = u1;
        this.texU2 = u1 + 0.0625f;
        this.texV1 = 0.0f;
        this.texV2 = 1.0f;
        this.scale = scale;
        float theRotation = MathStuff.toRadians(-rotation + 180.0f);
        this.firstPoint = MathStuff.rotateScale(FIRST_POINT, theRotation, this.scale);
        this.secondPoint = MathStuff.rotateScale(SECOND_POINT, theRotation, this.scale);
        this.thirdPoint = MathStuff.rotateScale(THIRD_POINT, theRotation, this.scale);
        this.fourthPoint = MathStuff.rotateScale(FOURTH_POINT, theRotation, this.scale);
    }

    @Override
    protected boolean advanceAge() {
        if (this.world instanceof Level && ((Level)this.world).m_46471_()) {
            this.age = (int)((float)this.age + WorldUtils.getRainStrength((Level)this.world, 1.0f) * 100.0f / 25.0f);
        }
        return super.advanceAge();
    }

    @Override
    protected void update() {
        if (this.isSnowLayer && this.world.m_8055_((BlockPos)this.position).m_60734_() != Blocks.f_50125_) {
            this.kill();
        } else {
            BlockState state = this.world.m_8055_(this.downPos);
            if (!state.m_60767_().m_76333_()) {
                this.kill();
            }
        }
    }

    @Override
    public void renderParticle(@Nonnull VertexConsumer buffer, @Nonnull Camera info, float partialTicks) {
        float f = ((float)this.age + partialTicks) / ((float)this.maxAge + 1.0f);
        f *= f;
        this.alpha = MathStuff.clamp1(1.0f - f) * 0.4f;
        double x = this.renderX(info, partialTicks);
        double y = this.renderY(info, partialTicks);
        double z = this.renderZ(info, partialTicks);
        this.drawVertex(buffer, x + (double)this.firstPoint.f_82470_, y, z + (double)this.firstPoint.f_82471_, this.texU1, this.texV2);
        this.drawVertex(buffer, x + (double)this.secondPoint.f_82470_, y, z + (double)this.secondPoint.f_82471_, this.texU2, this.texV2);
        this.drawVertex(buffer, x + (double)this.thirdPoint.f_82470_, y, z + (double)this.thirdPoint.f_82471_, this.texU2, this.texV1);
        this.drawVertex(buffer, x + (double)this.fourthPoint.f_82470_, y, z + (double)this.fourthPoint.f_82471_, this.texU1, this.texV1);
    }
}

