/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.footsteps.facade.FacadeHelper;
import org.orecruncher.mobeffects.library.FootstepLibrary;

@OnlyIn(value=Dist.CLIENT)
public final class FootStrikeLocation {
    private final LivingEntity entity;
    private final Vec3 strike;
    private final BlockPos stepPos;

    public FootStrikeLocation(@Nonnull LivingEntity entity, double x, double y, double z) {
        this(entity, new Vec3(x, y, z));
    }

    public FootStrikeLocation(@Nonnull LivingEntity entity, @Nonnull Vec3 loc) {
        this.entity = entity;
        this.strike = loc;
        this.stepPos = new BlockPos(loc);
    }

    protected FootStrikeLocation(@Nonnull LivingEntity entity, @Nonnull Vec3 loc, @Nonnull BlockPos pos) {
        this.entity = entity;
        this.strike = loc;
        this.stepPos = pos;
    }

    public FootStrikeLocation rebase(@Nonnull BlockPos pos) {
        if (!this.stepPos.equals((Object)pos)) {
            return new FootStrikeLocation(this.entity, this.strike, pos);
        }
        return this;
    }

    @Nonnull
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Nonnull
    public BlockPos getStepPos() {
        return this.stepPos;
    }

    @Nonnull
    public Vec3 getStrikePosition() {
        return this.strike;
    }

    public Vec3 north() {
        return this.offset(Direction.NORTH, 1.0f);
    }

    public Vec3 south() {
        return this.offset(Direction.SOUTH, 1.0f);
    }

    public Vec3 east() {
        return this.offset(Direction.EAST, 1.0f);
    }

    public Vec3 west() {
        return this.offset(Direction.WEST, 1.0f);
    }

    public Vec3 up() {
        return this.offset(Direction.UP, 1.0f);
    }

    public Vec3 down() {
        return this.offset(Direction.DOWN, 1.0f);
    }

    @Nonnull
    public Vec3 offset(@Nonnull Direction facing, float n) {
        return n == 0.0f ? this.strike : new Vec3(this.strike.f_82479_ + (double)((float)facing.m_122429_() * n), this.strike.f_82480_ + (double)((float)facing.m_122430_() * n), this.strike.f_82481_ + (double)((float)facing.m_122431_() * n));
    }

    @Nullable
    protected Vec3 footprintPosition() {
        Level world = this.entity.m_20193_();
        BlockState state = world.m_8055_(this.stepPos);
        if (state.m_60767_() == Material.f_76296_) {
            return null;
        }
        BlockPos feetPos = this.stepPos.m_7494_();
        BlockState upState = world.m_8055_(feetPos);
        if (upState.m_60767_() != Material.f_76296_) {
            state = upState;
        } else {
            feetPos = this.stepPos;
        }
        if (!this.hasFootstepImprint(state, feetPos)) {
            return null;
        }
        VoxelShape shape = state.m_60812_((BlockGetter)world, feetPos);
        double boundingY = state.m_60808_((BlockGetter)world, feetPos).m_83297_(Direction.Axis.Y);
        double collisionY = shape.m_83281_() ? 0.0 : shape.m_83297_(Direction.Axis.Y);
        double maxYblock = (double)feetPos.m_123342_() + Math.max(boundingY, collisionY);
        return new Vec3(this.strike.m_7096_(), maxYblock, this.strike.m_7094_());
    }

    protected boolean hasFootstepImprint(@Nonnull BlockState state, @Nonnull BlockPos pos) {
        BlockState footstepState = FacadeHelper.resolveState(this.entity, state, (LevelReader)this.entity.m_20193_(), Vec3.m_82512_((Vec3i)pos), Direction.UP);
        return FootstepLibrary.hasFootprint(footstepState);
    }
}

