/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps;

import javax.annotation.Nonnull;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.footsteps.Generator;
import org.orecruncher.mobeffects.footsteps.Variator;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.sndctrl.api.acoustics.AcousticEvent;

@OnlyIn(value=Dist.CLIENT)
public class GeneratorQP
extends Generator {
    private static final int USE_FUNCTION = 2;
    private int hoof = 0;
    private float nextWalkDistanceMultiplier = 0.05f;

    public GeneratorQP(@Nonnull Variator var) {
        super(var);
    }

    @Override
    protected void stepped(@Nonnull LivingEntity ply, @Nonnull AcousticEvent event) {
        if (this.hoof == 0 || this.hoof == 2) {
            this.nextWalkDistanceMultiplier = RANDOM.nextFloat();
        }
        this.hoof = this.hoof >= 3 ? 0 : ++this.hoof;
        if (this.hoof == 3 && event == Constants.RUN) {
            this.produceStep(ply, event);
            this.hoof = 0;
        }
        if (event == Constants.WALK) {
            this.produceStep(ply, event);
        }
    }

    protected float walkFunction2(float distance) {
        float overallMultiplier = this.VAR.QUADRUPED_MULTIPLIER;
        float ndm = 0.2f;
        float pond = this.nextWalkDistanceMultiplier;
        pond *= pond;
        pond *= 0.2f;
        if (this.hoof == 1 || this.hoof == 3) {
            return distance * pond * overallMultiplier;
        }
        return distance * (1.0f - pond) * overallMultiplier;
    }

    protected float walkFunction1(float distance) {
        float overallMultiplier = 1.4f;
        float ndm = 0.5f;
        if (this.hoof == 1 || this.hoof == 3) {
            return distance * (0.5f + this.nextWalkDistanceMultiplier * 0.5f * 0.5f) * 1.4f;
        }
        return distance * 0.5f * 1.4f;
    }

    protected float walkFunction0(float distance) {
        float overallMultiplier = 1.5f;
        float ndm = 0.425f + this.nextWalkDistanceMultiplier * 0.15f;
        if (this.hoof == 1 || this.hoof == 3) {
            return distance * ndm * 1.5f;
        }
        return distance * (1.0f - ndm) * 1.5f;
    }

    @Override
    protected float reevaluateDistance(@Nonnull AcousticEvent event, float distance) {
        if (event == Constants.WALK) {
            switch (2) {
                case 0: {
                    return this.walkFunction0(distance);
                }
                case 1: {
                    return this.walkFunction1(distance);
                }
            }
            return this.walkFunction2(distance);
        }
        if (event == Constants.RUN && this.hoof == 0) {
            return distance * 0.8f;
        }
        if (event == Constants.RUN) {
            return distance * 0.3f;
        }
        return distance;
    }
}

