/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps.accents;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.footsteps.accents.IFootstepAccentProvider;
import org.orecruncher.mobeffects.library.FootstepLibrary;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;

@OnlyIn(value=Dist.CLIENT)
class RainSplashAccent
implements IFootstepAccentProvider {
    RainSplashAccent() {
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.CLIENT.footsteps.enableRainSplashAccent.get();
    }

    @Override
    public void provide(@Nonnull LivingEntity entity, @Nonnull BlockPos blockPos, @Nonnull BlockState posState, @Nonnull ObjectArray<IAcoustic> acoustics) {
        Biome.Precipitation rainType;
        Level world = entity.m_20193_();
        if (world.m_46471_() && (rainType = WorldUtils.getCurrentPrecipitationAt((LevelReader)world, blockPos.m_7494_())) == Biome.Precipitation.RAIN) {
            acoustics.add(FootstepLibrary.getRainSplashAcoustic());
        }
    }
}

