/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps.facade;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.mobeffects.MobEffects;
import org.orecruncher.mobeffects.footsteps.facade.IFacadeAccessor;

@OnlyIn(value=Dist.CLIENT)
class FacadeAccessor
implements IFacadeAccessor {
    protected Class<?> IFacadeClass;
    protected Method accessor;

    public FacadeAccessor(@Nonnull String clazz, @Nonnull String method) {
        try {
            this.IFacadeClass = Class.forName(clazz);
            this.accessor = this.getMethod(method);
        }
        catch (Throwable t) {
            this.IFacadeClass = null;
            this.accessor = null;
        }
    }

    @Override
    @Nonnull
    public String getName() {
        return this.isValid() ? this.IFacadeClass.getName() : "INVALID";
    }

    @Override
    public boolean instanceOf(@Nonnull Block block) {
        return this.isValid() && this.IFacadeClass.isInstance(block);
    }

    @Override
    public boolean isValid() {
        return this.accessor != null;
    }

    @Override
    @Nullable
    public BlockState getBlockState(@Nonnull LivingEntity entity, @Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull Vec3 pos, @Nullable Direction side) {
        if (this.isValid()) {
            try {
                if (this.instanceOf(state.m_60734_())) {
                    return this.call(state, world, new BlockPos(pos), side);
                }
            }
            catch (Throwable ex) {
                MobEffects.LOGGER.error(ex, "Error!", new Object[0]);
                this.IFacadeClass = null;
                this.accessor = null;
            }
        }
        return null;
    }

    protected Method getMethod(@Nonnull String method) throws Throwable {
        return this.IFacadeClass.getMethod(method, BlockGetter.class, BlockPos.class, Direction.class);
    }

    protected BlockState call(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nullable Direction side) throws Throwable {
        return (BlockState)this.accessor.invoke((Object)state.m_60734_(), world, pos, side);
    }
}

