/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.api;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.orecruncher.lib.Utilities;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.acoustics.AcousticEvent;
import org.orecruncher.sndctrl.api.effects.IEntityEffectFactoryHandler;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.library.EntityEffectLibrary;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class IMC {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(IMC.class);
    private static final ObjectArray<Runnable> callbacks = new ObjectArray(4);

    private IMC() {
    }

    private static void processIMC(@Nonnull InterModProcessEvent event) {
        event.getIMCStream().forEach(msg -> {
            try {
                Methods method = Methods.valueOf(msg.getMethod());
                method.handle((InterModComms.IMCMessage)msg);
            }
            catch (Throwable t) {
                SoundControl.LOGGER.warn("Unable to process IMC message '%s' - unrecognized?", msg.getMethod());
            }
        });
    }

    private static void registerAcousticEventHandler(@Nonnull InterModComms.IMCMessage msg) {
        IMC.handle(msg, AcousticEvent.class, AcousticEvent::register);
    }

    private static void registerSoundCategoryHandler(@Nonnull InterModComms.IMCMessage msg) {
        IMC.handle(msg, ISoundCategory.class, Category::register);
    }

    private static void registerEffectFactoryHandlerHandler(@Nonnull InterModComms.IMCMessage msg) {
        IMC.handle(msg, IEntityEffectFactoryHandler.class, EntityEffectLibrary::register);
    }

    private static void registerCompletionCallbackHandler(@Nonnull InterModComms.IMCMessage msg) {
        Utilities.safeCast(msg.getMessageSupplier().get(), Runnable.class).ifPresent(callbacks::add);
    }

    private static <T> void handle(@Nonnull InterModComms.IMCMessage msg, @Nonnull Class<T> clazz, @Nonnull Consumer<T> handler) {
        Utilities.safeCast(msg.getMessageSupplier().get(), clazz).ifPresent(handler);
    }

    public static void registerAcousticEvent(AcousticEvent ... event) {
        for (AcousticEvent e : event) {
            Methods.REGISTER_ACOUSTIC_EVENT.send(() -> e);
        }
    }

    public static void registerSoundCategory(ISoundCategory ... category) {
        for (ISoundCategory c : category) {
            Methods.REGISTER_SOUND_CATEGORY.send(() -> c);
        }
    }

    public static void registerEffectFactoryHandler(IEntityEffectFactoryHandler ... handler) {
        for (IEntityEffectFactoryHandler h : handler) {
            Methods.REGISTER_EFFECT_FACTORY_HANDLER.send(() -> h);
        }
    }

    public static void registerCompletionCallback(Runnable ... callback) {
        for (Runnable r : callback) {
            Methods.REGISTER_COMPLETION_CALLBACK.send(() -> r);
        }
    }

    public static void processCompletions() {
        for (Runnable r : callbacks) {
            try {
                r.run();
            }
            catch (Throwable t) {
                LOGGER.error(t, "Error executing completion processing routine", new Object[0]);
            }
        }
        callbacks.clear();
    }

    static {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(IMC::processIMC);
    }

    private static enum Methods {
        REGISTER_ACOUSTIC_EVENT(IMC::registerAcousticEventHandler),
        REGISTER_SOUND_CATEGORY(IMC::registerSoundCategoryHandler),
        REGISTER_EFFECT_FACTORY_HANDLER(IMC::registerEffectFactoryHandlerHandler),
        REGISTER_COMPLETION_CALLBACK(IMC::registerCompletionCallbackHandler);

        private final Consumer<InterModComms.IMCMessage> handler;

        private Methods(Consumer<InterModComms.IMCMessage> handler) {
            this.handler = handler;
        }

        public void handle(@Nonnull InterModComms.IMCMessage msg) {
            LOGGER.debug("Processing IMC message '%s' from '%s'", msg.getMethod(), msg.getSenderModId());
            try {
                this.handler.accept(msg);
            }
            catch (Throwable t) {
                LOGGER.error(t, "Error processing IMC message", new Object[0]);
            }
        }

        public void send(@Nonnull Supplier<?> sup) {
            InterModComms.sendTo((String)"sndctrl", (String)this.name(), sup);
        }
    }
}

