/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.api.acoustics;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class AcousticEvent {
    private static final Map<ResourceLocation, AcousticEvent> mapping = new HashMap<ResourceLocation, AcousticEvent>();
    @Nonnull
    public static final AcousticEvent NONE = new AcousticEvent(new ResourceLocation("sndctrl", "none"), null).register();
    private final ResourceLocation name;
    private final AcousticEvent transition;

    public AcousticEvent(@Nonnull ResourceLocation name, @Nullable AcousticEvent transition) {
        this.name = name;
        this.transition = transition;
    }

    @Nullable
    public static AcousticEvent getEvent(@Nonnull ResourceLocation name) {
        return mapping.get(name);
    }

    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    public boolean canTransition() {
        return this.transition != null;
    }

    @Nullable
    public AcousticEvent getTransition() {
        return this.transition;
    }

    @Nonnull
    public AcousticEvent register() {
        mapping.put(this.name, this);
        return this;
    }

    public String toString() {
        MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((Object)this).addValue((Object)this.name.toString());
        if (this.transition != null) {
            builder.add("transition", (Object)this.transition.getName());
        }
        return builder.toString();
    }
}

