/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.SoundState;
import org.orecruncher.sndctrl.audio.handlers.SoundVolumeEvaluator;

@OnlyIn(value=Dist.CLIENT)
public class DSSoundInstance
extends AbstractSoundInstance
implements ISoundInstance {
    private SoundState state = SoundState.NONE;
    private final ISoundCategory category;
    private int playDelay;

    public DSSoundInstance(@Nonnull SoundEvent event, @Nonnull ISoundCategory cat) {
        this(event.m_11660_(), cat);
    }

    public DSSoundInstance(@Nonnull ResourceLocation soundResource, @Nonnull ISoundCategory cat) {
        super(soundResource, cat.getRealCategory(), (RandomSource)new XoroshiroRandomSource(0L));
        this.category = cat;
        this.f_119573_ = 1.0f;
        this.f_119574_ = 1.0f;
        this.f_119577_ = 0.0;
        this.f_119576_ = 0.0;
        this.f_119575_ = 0.0;
        this.f_119578_ = false;
        this.f_119579_ = 0;
        this.f_119580_ = SoundInstance.Attenuation.LINEAR;
        this.playDelay = 0;
        this.f_119570_ = SoundManager.f_120344_;
        this.m_6775_(GameUtils.getSoundHander());
    }

    @Override
    @Nonnull
    public ISoundCategory getSoundCategory() {
        return this.category;
    }

    @Override
    @Nonnull
    public SoundState getState() {
        return this.state;
    }

    @Override
    public void setState(@Nonnull SoundState state) {
        this.state = state;
    }

    public void setPitch(float p) {
        this.f_119574_ = p;
    }

    public void setPosition(float x, float y, float z) {
        this.f_119575_ = x;
        this.f_119576_ = y;
        this.f_119577_ = z;
    }

    public void setPosition(@Nonnull Vec3i pos) {
        this.setPosition((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
    }

    public void setPosition(@Nonnull Vec3 pos) {
        this.setPosition((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_);
    }

    public void setAttenuationType(@Nonnull SoundInstance.Attenuation type) {
        this.f_119580_ = type;
    }

    public void setRepeat(boolean flag) {
        this.f_119578_ = flag;
    }

    public void setRepeatDelay(int delay) {
        this.f_119579_ = delay;
    }

    public void setVolume(float v) {
        this.f_119573_ = v;
    }

    @Override
    public void scaleVolume(float v) {
        this.f_119573_ *= v;
    }

    public void setGlobal(boolean flag) {
        this.f_119582_ = flag;
    }

    public boolean isDonePlaying() {
        return this.getState().isTerminal();
    }

    @Override
    public int getPlayDelay() {
        return this.playDelay;
    }

    @Override
    public void setPlayDelay(int delay) {
        this.playDelay = delay;
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.m_7904_().toString()).addValue((Object)this.getSoundCategory().toString()).addValue((Object)this.m_7438_().toString()).addValue((Object)this.getState().toString()).add("v", this.m_7769_()).add("ev", DSSoundInstance.getEffectiveVolume(this)).add("p", this.m_7783_()).add("x", this.m_7772_()).add("y", this.m_7780_()).add("z", this.m_7778_()).toString();
    }

    static float getEffectiveVolume(@Nonnull SoundInstance sound) {
        try {
            return SoundVolumeEvaluator.getClampedVolume(sound);
        }
        catch (Throwable throwable) {
            return -1.0f;
        }
    }
}

