/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.DSSoundInstance;
import org.orecruncher.sndctrl.audio.WrappedSoundInstance;

@OnlyIn(value=Dist.CLIENT)
public class EntitySoundInstance
extends WrappedSoundInstance {
    @Nonnull
    private final Entity entity;
    private float x;
    private float y;
    private float z;

    public EntitySoundInstance(@Nonnull Entity entity, @Nonnull ISoundInstance sound) {
        super(sound);
        this.entity = Objects.requireNonNull(entity);
        this.updatePosition();
    }

    @Override
    public double m_7772_() {
        return this.x;
    }

    @Override
    public double m_7780_() {
        return this.y;
    }

    @Override
    public double m_7778_() {
        return this.z;
    }

    @Override
    public boolean m_7801_() {
        return !this.entity.m_6084_() || super.m_7801_();
    }

    @Override
    public int getPlayDelay() {
        return this.sound.getPlayDelay();
    }

    @Override
    public void setPlayDelay(int delay) {
        this.sound.setPlayDelay(delay);
    }

    private void updatePosition() {
        Vec3 box = this.entity.m_20191_().m_82399_();
        this.x = (float)box.f_82479_;
        this.y = (float)box.f_82480_;
        this.z = (float)box.f_82481_;
    }

    @Override
    public void m_7788_() {
        super.m_7788_();
        if (!this.m_7801_() && !this.m_7796_()) {
            this.updatePosition();
        }
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.entity.toString()).addValue((Object)this.m_7904_().toString()).addValue((Object)this.m_8070_().toString()).addValue((Object)this.m_7438_().toString()).addValue((Object)this.getState().toString()).add("v", this.m_7769_()).add("ev", DSSoundInstance.getEffectiveVolume(this)).add("p", this.m_7783_()).add("x", this.m_7772_()).add("y", this.m_7780_()).add("z", this.m_7778_()).toString();
    }
}

