/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.library.config.SoundMetadataConfig;

@OnlyIn(value=Dist.CLIENT)
public final class SoundMetadata {
    private static final Component NO_STRING = Component.m_237119_();
    private final Component title;
    private final Component caption;
    private final ISoundCategory category;
    private final List<Component> credits;

    public SoundMetadata() {
        this.title = NO_STRING;
        this.caption = NO_STRING;
        this.category = Category.NEUTRAL;
        this.credits = ImmutableList.of();
    }

    public SoundMetadata(@Nonnull SoundMetadataConfig cfg) {
        Objects.requireNonNull(cfg);
        this.title = StringUtils.isEmpty((CharSequence)cfg.title) ? NO_STRING : Component.m_237115_((String)cfg.title);
        this.caption = StringUtils.isEmpty((CharSequence)cfg.caption) ? NO_STRING : Component.m_237115_((String)cfg.caption);
        this.category = Category.getCategory(cfg.category).orElse(Category.NEUTRAL);
        if (cfg.credits == null || cfg.credits.size() == 0) {
            this.credits = ImmutableList.of();
        } else {
            this.credits = new ArrayList<Component>();
            for (String s : cfg.credits) {
                if (StringUtils.isEmpty((CharSequence)s)) {
                    this.credits.add(NO_STRING);
                    continue;
                }
                this.credits.add((Component)Component.m_237113_((String)s));
            }
        }
    }

    @Nonnull
    public Component getTitle() {
        return this.title;
    }

    @Nonnull
    public Component getCaption() {
        return this.caption;
    }

    @Nonnull
    public List<Component> getCredits() {
        return this.credits;
    }

    @Nonnull
    public ISoundCategory getCategory() {
        return this.category;
    }
}

