/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.acoustic;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.sndctrl.api.acoustics.AcousticEvent;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.acoustics.IAcousticFactory;
import org.orecruncher.sndctrl.audio.acoustic.NullAcoustic;

@OnlyIn(value=Dist.CLIENT)
public class SimultaneousAcoustic
implements IAcoustic {
    @Nonnull
    private final ResourceLocation name;
    @Nonnull
    private final ObjectArray<IAcoustic> acoustics = new ObjectArray();

    public SimultaneousAcoustic(@Nonnull ResourceLocation name) {
        this.name = Objects.requireNonNull(name);
    }

    public void add(@Nonnull IAcoustic a) {
        if (!(a instanceof NullAcoustic)) {
            this.acoustics.add(a);
        }
    }

    public void trim() {
        this.acoustics.trim();
    }

    @Override
    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public void play(@Nonnull AcousticEvent event) {
        for (IAcoustic a : this.acoustics) {
            a.play(event);
        }
    }

    @Override
    public void playAt(@Nonnull BlockPos pos, @Nonnull AcousticEvent event) {
        for (IAcoustic a : this.acoustics) {
            a.playAt(pos, event);
        }
    }

    @Override
    public void playAt(@Nonnull Vec3 pos, @Nonnull AcousticEvent event) {
        for (IAcoustic a : this.acoustics) {
            a.playAt(pos, event);
        }
    }

    @Override
    public void playNear(@Nonnull Entity entity, @Nonnull AcousticEvent event) {
        for (IAcoustic a : this.acoustics) {
            a.playNear(entity, event);
        }
    }

    @Override
    public void playNear(@Nonnull Entity entity, @Nonnull AcousticEvent event, int minRange, int maxRange) {
        for (IAcoustic a : this.acoustics) {
            a.playNear(entity, event, minRange, maxRange);
        }
    }

    @Override
    public void playBackground(@Nonnull AcousticEvent event) {
        for (IAcoustic a : this.acoustics) {
            a.playBackground(event);
        }
    }

    @Override
    public IAcousticFactory getFactory(@Nonnull AcousticEvent event) {
        if (this.acoustics.size() > 0) {
            return this.acoustics.get(0).getFactory();
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName().toString()).add("entries", this.acoustics.size()).toString();
    }
}

