/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.AudioEngine;
import org.orecruncher.sndctrl.events.AudioEvent;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class MusicFader {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(MusicFader.class);
    private static final float MIN_VOLUME_SCALE = 0.001f;
    private static final float FADE_AMOUNT = 0.02f;
    private static float currentScale = 1.0f;
    @Nullable
    private static ISoundInstance playingConfigSound;

    private MusicFader() {
    }

    public static float getMusicScaling() {
        return currentScale;
    }

    @SubscribeEvent
    public static void onTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.side != LogicalSide.CLIENT || event.phase == TickEvent.Phase.END) {
            return;
        }
        float oldScale = currentScale;
        if (playingConfigSound != null && playingConfigSound.getState().isTerminal()) {
            MusicFader.stopConfigSound(playingConfigSound);
        }
        if (playingConfigSound == null) {
            AudioEvent.MusicFadeAudioEvent doFade = new AudioEvent.MusicFadeAudioEvent();
            MinecraftForge.EVENT_BUS.post((Event)doFade);
            currentScale = doFade.isCanceled() ? (currentScale -= 0.02f) : (currentScale += 0.02f);
        }
        if (Float.compare(oldScale, currentScale = MathStuff.clamp(currentScale, 0.001f, 1.0f)) != 0) {
            float mcScale = GameUtils.getGameSettings().m_92147_(SoundSource.MUSIC);
            GameUtils.getSoundHander().m_120358_(SoundSource.MUSIC, mcScale);
        }
    }

    public static void playConfigSound(@Nonnull ISoundInstance sound) {
        playingConfigSound = Objects.requireNonNull(sound);
        currentScale = 0.001f;
        AudioEngine.stopAll();
        AudioEngine.play(sound);
    }

    public static void stopConfigSound(@Nonnull ISoundInstance sound) {
        if (playingConfigSound != null) {
            if (playingConfigSound != Objects.requireNonNull(sound)) {
                LOGGER.warn("Inconsistent sound in MusicFader", new Object[0]);
            }
            AudioEngine.stop(playingConfigSound);
            playingConfigSound = null;
        }
    }

    public static boolean isConfigSoundInstance(@Nonnull SoundInstance sound) {
        return playingConfigSound == Objects.requireNonNull(sound);
    }
}

