/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.sndctrl.audio.SoundUtils;
import org.orecruncher.sndctrl.audio.handlers.MusicFader;
import org.orecruncher.sndctrl.config.Config;
import org.orecruncher.sndctrl.library.IndividualSoundConfig;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class SoundProcessor {
    private static final float MIN_SOUNDFACTOR = 0.0f;
    private static final float MAX_SOUNDFACTOR = 4.0f;
    private static final float DEFAULT_SOUNDFACTOR = 1.0f;
    private static final Set<ResourceLocation> blockedSounds = new ObjectOpenHashSet(32);
    private static final Object2LongOpenHashMap<ResourceLocation> soundCull = new Object2LongOpenHashMap(32);
    private static final Object2FloatOpenHashMap<ResourceLocation> volumeControl = new Object2FloatOpenHashMap(32);
    private static int cullInterval = 20;

    private SoundProcessor() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigLoad(@Nonnull ModConfigEvent.Loading configEvent) {
        SoundProcessor.applyConfig();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigChange(@Nonnull ModConfigEvent.Reloading configEvent) {
        SoundProcessor.applyConfig();
    }

    public static void applyConfig() {
        soundCull.clear();
        blockedSounds.clear();
        volumeControl.clear();
        cullInterval = (Integer)Config.CLIENT.sound.cullInterval.get();
        List configs = ((List)Config.CLIENT.sound.individualSounds.get()).stream().map(IndividualSoundConfig::createFrom).filter(Objects::nonNull).filter(cfg -> !cfg.isDefault()).collect(Collectors.toList());
        for (IndividualSoundConfig cfg2 : configs) {
            if (cfg2.isBlocked()) {
                blockedSounds.add(cfg2.getLocation());
            }
            if (cfg2.isCulled()) {
                soundCull.put((Object)cfg2.getLocation(), (long)(-cullInterval));
            }
            if (cfg2.getVolumeScaleInt() == 100) continue;
            volumeControl.put((Object)cfg2.getLocation(), MathStuff.clamp(cfg2.getVolumeScale(), 0.0f, 4.0f));
        }
    }

    public static boolean isSoundBlocked(@Nonnull ResourceLocation sound) {
        return blockedSounds.contains(Objects.requireNonNull(sound));
    }

    public static float getVolumeScale(@Nonnull ResourceLocation sound) {
        return volumeControl.getFloat((Object)Objects.requireNonNull(sound));
    }

    public static float getVolumeScale(@Nonnull SoundInstance sound) {
        return SoundProcessor.getVolumeScale(Objects.requireNonNull(sound).m_7904_());
    }

    private static boolean isSoundCulledLogical(@Nonnull ResourceLocation sound) {
        long lastOccurance;
        if (cullInterval > 0 && (lastOccurance = soundCull.getLong((Object)Objects.requireNonNull(sound))) != 0L) {
            long currentTick = TickCounter.getTickCount();
            if (currentTick - lastOccurance < (long)cullInterval) {
                return true;
            }
            soundCull.put((Object)sound, currentTick);
        }
        return false;
    }

    private static boolean blockSoundProcess(@Nonnull ResourceLocation res) {
        return SoundProcessor.isSoundBlocked(res) || SoundProcessor.isSoundCulledLogical(res);
    }

    private static void soundPlay(@Nonnull PlaySoundEvent e) {
        SoundInstance theSound = e.getSound();
        if (theSound == null || !SoundUtils.hasRoom()) {
            e.setSound(null);
            e.setResult(null);
            return;
        }
        if (MusicFader.isConfigSoundInstance(theSound)) {
            return;
        }
        ResourceLocation soundResource = theSound.m_7904_();
        if (SoundProcessor.blockSoundProcess(soundResource)) {
            e.setSound(null);
            e.setResult(null);
        }
    }

    static {
        volumeControl.defaultReturnValue(1.0f);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, SoundProcessor::soundPlay);
    }
}

