/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import com.google.common.base.MoreObjects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.random.LCGRandom;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.audio.SoundUtils;
import org.orecruncher.sndctrl.audio.handlers.Effects;
import org.orecruncher.sndctrl.audio.handlers.SoundFXProcessor;
import org.orecruncher.sndctrl.audio.handlers.SoundFXUtils;
import org.orecruncher.sndctrl.audio.handlers.effects.LowPassData;
import org.orecruncher.sndctrl.audio.handlers.effects.SourcePropertyFloat;

@OnlyIn(value=Dist.CLIENT)
public final class SourceContext
implements Callable<Void> {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(SourceContext.class);
    private static final LCGRandom RANDOM = new LCGRandom();
    private static final int UPDATE_FEQUENCY_TICKS = 7;
    private final Object sync = new Object();
    private final LowPassData lowPass0;
    private final LowPassData lowPass1;
    private final LowPassData lowPass2;
    private final LowPassData lowPass3;
    private final LowPassData direct;
    private final SourcePropertyFloat airAbsorb;
    private final SoundFXUtils fxProcessor;
    private SoundInstance sound;
    private Vec3 pos;
    private ISoundCategory category = Category.MASTER;
    private boolean isEnabled;
    private int updateCount;

    public SourceContext() {
        this.lowPass0 = new LowPassData();
        this.lowPass1 = new LowPassData();
        this.lowPass2 = new LowPassData();
        this.lowPass3 = new LowPassData();
        this.direct = new LowPassData();
        this.airAbsorb = new SourcePropertyFloat(131079, 0.0f, 0.0f, 10.0f);
        this.pos = Vec3.f_82478_;
        this.fxProcessor = new SoundFXUtils(this);
    }

    public Object sync() {
        return this.sync;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void enable() {
        this.isEnabled = true;
    }

    @Nonnull
    public LowPassData getLowPass0() {
        return this.lowPass0;
    }

    @Nonnull
    public LowPassData getLowPass1() {
        return this.lowPass1;
    }

    @Nonnull
    public LowPassData getLowPass2() {
        return this.lowPass2;
    }

    @Nonnull
    public LowPassData getLowPass3() {
        return this.lowPass3;
    }

    @Nonnull
    public LowPassData getDirect() {
        return this.direct;
    }

    @Nonnull
    public SourcePropertyFloat getAirAbsorb() {
        return this.airAbsorb;
    }

    @Nonnull
    public Vec3 getPosition() {
        return this.pos;
    }

    @Nonnull
    public ISoundCategory getCategory() {
        return this.category;
    }

    public void attachSound(@Nonnull SoundInstance sound) {
        this.sound = sound;
        this.category = Category.getCategory(sound).orElse(Category.MASTER);
        this.captureState();
    }

    @Nullable
    public SoundInstance getSound() {
        return this.sound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(int sourceId) {
        if (this.isEnabled()) {
            Object object = this.sync();
            synchronized (object) {
                Effects.filter0.apply(sourceId, this.lowPass0, 0, Effects.auxSlot0);
                Effects.filter1.apply(sourceId, this.lowPass1, 1, Effects.auxSlot1);
                Effects.filter2.apply(sourceId, this.lowPass2, 2, Effects.auxSlot2);
                Effects.filter3.apply(sourceId, this.lowPass3, 3, Effects.auxSlot3);
                Effects.direct.apply(sourceId, this.direct);
                this.airAbsorb.apply(sourceId);
                SoundFXProcessor.validate("SourceHandler::tick");
            }
        }
    }

    public boolean shouldExecute() {
        if (this.updateCount == 0) {
            this.updateCount = RANDOM.nextInt(7);
        }
        return this.updateCount++ % 7 == 0;
    }

    @Override
    public Void call() throws Exception {
        this.captureState();
        this.updateImpl();
        return null;
    }

    public final void exec() {
        this.captureState();
        this.updateImpl();
    }

    private void updateImpl() {
        try {
            this.fxProcessor.calculate(SoundFXProcessor.getWorldContext());
        }
        catch (Throwable t) {
            LOGGER.error(t, "Error processing SoundContext %s", this.toString());
        }
    }

    private void captureState() {
        if (this.sound != null) {
            this.pos = new Vec3(this.sound.m_7772_(), this.sound.m_7780_(), this.sound.m_7778_());
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)SoundUtils.debugString(this.sound)).toString();
    }
}

