/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.sndctrl.gui.IndividualSoundControlListEntry;
import org.orecruncher.sndctrl.library.IndividualSoundConfig;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public class IndividualSoundControlList
extends ContainerObjectSelectionList<IndividualSoundControlListEntry> {
    private final Screen parent;
    private final boolean enablePlay;
    private final int width;
    private List<IndividualSoundConfig> source;
    private String lastSearchText = null;

    public IndividualSoundControlList(@Nonnull Screen parent, @Nonnull Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotWidth, int slotHeightIn, boolean enablePlay, @Nonnull Supplier<String> filter, @Nullable IndividualSoundControlList oldList) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.parent = parent;
        this.enablePlay = enablePlay;
        this.width = slotWidth;
        if (oldList != null) {
            this.source = oldList.source;
        }
        this.setSearchFilter(filter, false);
    }

    public void tick() {
        this.m_6702_().stream().map(IndividualSoundControlListEntry.class::cast).forEach(IndividualSoundControlListEntry::tick);
    }

    public int m_5759_() {
        return this.width;
    }

    protected int m_5756_() {
        return (this.parent.f_96543_ + this.m_5759_()) / 2 + 20;
    }

    public void setSearchFilter(@Nonnull Supplier<String> filterBy, boolean forceReload) {
        String filter = filterBy.get();
        if (!forceReload && this.lastSearchText != null && this.lastSearchText.equals(filter)) {
            return;
        }
        this.lastSearchText = filter;
        this.m_93516_();
        if (this.source == null || forceReload) {
            this.source = new ArrayList<IndividualSoundConfig>(SoundLibrary.getSortedSoundConfigurations());
        }
        Function<IndividualSoundConfig, Boolean> process = StringUtil.m_14408_((String)filter) ? isc -> true : isc -> isc.getLocation().toString().contains(filter);
        IndividualSoundControlListEntry first = null;
        for (IndividualSoundConfig cfg : this.source) {
            if (!process.apply(cfg).booleanValue()) continue;
            IndividualSoundControlListEntry entry = new IndividualSoundControlListEntry(cfg, this.enablePlay);
            if (first == null) {
                first = entry;
            }
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }
        if (first != null) {
            this.m_93498_((AbstractSelectionList.Entry)first);
        }
    }

    @Nullable
    public IndividualSoundControlListEntry getEntryAt(int mouseX, int mouseY) {
        return (IndividualSoundControlListEntry)this.m_93412_(mouseX, mouseY);
    }

    @Nonnull
    protected Collection<IndividualSoundConfig> getConfigs() {
        ArrayList<IndividualSoundConfig> configs = new ArrayList<IndividualSoundConfig>();
        for (IndividualSoundConfig cfg : this.source) {
            if (cfg.isDefault()) continue;
            configs.add(cfg);
        }
        return configs;
    }

    public void saveChanges() {
        SoundLibrary.updateSoundConfigurations(this.getConfigs());
    }
}

