/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.sndctrl.gui.IndividualSoundControlList;
import org.orecruncher.sndctrl.gui.IndividualSoundControlListEntry;

@OnlyIn(value=Dist.CLIENT)
public class IndividualSoundControlScreen
extends Screen {
    private static final int TOP_OFFSET = 10;
    private static final int BOTTOM_OFFSET = 15;
    private static final int HEADER_HEIGHT = 35;
    private static final int FOOTER_HEIGHT = 50;
    private static final int SEARCH_BAR_WIDTH = 200;
    private static final int SEARCH_BAR_HEIGHT = 20;
    private static final int SELECTION_HEIGHT_OFFSET = 5;
    private static final int SELECTION_WIDTH = 600;
    private static final int SELECTION_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 10;
    private static final int CONTROL_WIDTH = 130;
    private static final int TOOLTIP_Y_OFFSET = 30;
    private static final Component SAVE = Component.m_237115_((String)"gui.done");
    private static final Component CANCEL = Component.m_237115_((String)"gui.cancel");
    protected final Screen parent;
    protected final boolean enablePlay;
    protected EditBox searchField;
    protected IndividualSoundControlList soundConfigList;
    protected Button save;
    protected Button cancel;

    protected IndividualSoundControlScreen(@Nullable Screen parent, boolean enablePlay) {
        super((Component)Component.m_237115_((String)"sndctrl.text.soundconfig.title"));
        this.parent = parent;
        this.enablePlay = enablePlay;
    }

    protected void m_7856_() {
        GameUtils.getMC().f_91068_.m_90926_(true);
        int searchBarLeftMargin = (this.f_96543_ - 200) / 2;
        int searchBarY = 25;
        this.searchField = new EditBox(this.f_96547_, searchBarLeftMargin, 25, 200, 20, this.searchField, (Component)Component.m_237119_());
        this.searchField.m_94151_(filter -> this.soundConfigList.setSearchFilter(() -> filter, false));
        this.m_142416_((GuiEventListener)this.searchField);
        int topY = 50;
        int bottomY = this.f_96544_ - 15 - 50 - 5;
        this.soundConfigList = new IndividualSoundControlList(this, GameUtils.getMC(), this.f_96543_, this.f_96544_, 50, bottomY, 600, 20, this.enablePlay, () -> this.searchField.m_94155_(), this.soundConfigList);
        this.m_142416_((GuiEventListener)this.soundConfigList);
        int controlMargin = (this.f_96543_ - 130) / 2;
        int controlHeight = this.f_96544_ - 15 - 20;
        this.save = new Button(controlMargin, controlHeight, 60, 20, SAVE, this::save);
        this.m_142416_((GuiEventListener)this.save);
        this.cancel = new Button(controlMargin + 60 + 10, controlHeight, 60, 20, CANCEL, this::cancel);
        this.m_142416_((GuiEventListener)this.cancel);
        this.m_94718_((GuiEventListener)this.searchField);
    }

    public void m_86600_() {
        this.searchField.m_94120_();
        this.soundConfigList.tick();
    }

    public boolean m_7043_() {
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers) || this.searchField.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        GameUtils.getMC().m_91152_(this.parent);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.searchField.m_5534_(codePoint, modifiers);
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        IndividualSoundControlListEntry entry;
        this.m_96626_(0);
        this.soundConfigList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        IndividualSoundControlScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)0xFFFFFF);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.soundConfigList.m_5953_(mouseX, mouseY) && (entry = this.soundConfigList.getEntryAt(mouseX, mouseY)) != null) {
            List<Component> toolTip = entry.getToolTip(mouseX, mouseY);
            this.renderTooltip(matrixStack, toolTip, Optional.empty(), mouseX, mouseY + 30, GameUtils.getMC().f_91062_);
        }
    }

    protected void save(@Nonnull Button button) {
        this.soundConfigList.saveChanges();
        this.m_7861_();
        this.m_7379_();
    }

    protected void cancel(@Nonnull Button button) {
        this.m_7861_();
        this.m_7379_();
    }
}

