/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import net.minecraftforge.common.ForgeConfigSpec;
import org.orecruncher.lib.gui.ColorPalette;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.config.Config;
import org.orecruncher.sndctrl.gui.DSlider;

@OnlyIn(value=Dist.CLIENT)
public class QuickVolumeScreen
extends Screen {
    private static final int CONTROL_WIDTH = 160;
    private static final int CONTROL_HEIGHT = 20;
    private static final int CONTROL_SPACING = 5;
    private static final Button.OnPress NULL_PRESSABLE = b -> {};
    private static final Component SUFFIX = Component.m_237113_((String)"%");
    private static final Component FOOTER = Component.m_237115_((String)"sndctrl.text.quickvolumemenu.footer");
    private static final Component TITLE = Component.m_237115_((String)"sndctrl.text.quickvolumemenu.title");
    private static final Component OCCLUSION = Component.m_237115_((String)"sndctrl.text.quickvolumemenu.occlusion");
    private final List<ISoundCategory> categories = new ArrayList<ISoundCategory>();
    final List<Float> categoryValues = new ArrayList<Float>();
    private final List<ForgeSlider> sliders = new ArrayList<ForgeSlider>();
    private Button occlusionToggle;
    private int footerY;

    protected QuickVolumeScreen() {
        super(TITLE);
    }

    protected void m_7856_() {
        this.categories.clear();
        this.sliders.clear();
        this.categories.addAll(Category.getCategoriesForMenu());
        for (ISoundCategory cat : this.categories) {
            this.categoryValues.add(Float.valueOf(cat.getVolumeScale()));
        }
        int leftSide = (this.f_96543_ - 160) / 2;
        int totalHeight = (this.categories.size() + 1) * 25;
        int top = (this.f_96544_ - totalHeight) / 2;
        int index = 0;
        for (ISoundCategory category : this.categories) {
            DSlider slider = new DSlider(leftSide, top, 160, 20, this.getSliderLabel(category.getTextComponent()), SUFFIX, 0.0, 100.0, (int)(category.getVolumeScale() * 100.0f), true, index);
            slider.f_93621_ = top;
            top += 25;
            slider.setParent(this);
            this.m_142416_((GuiEventListener)slider);
            this.sliders.add(slider);
            ++index;
        }
        this.occlusionToggle = new Button(leftSide, top, 160, 20, this.generateTextForSetting(Config.CLIENT.sound.enableOcclusionCalcs), this::buttonPress);
        this.m_142416_((GuiEventListener)this.occlusionToggle);
        this.footerY = top += 25;
    }

    protected void buttonPress(@Nonnull Button button) {
        Config.CLIENT.sound.enableOcclusionCalcs.set((Object)((Boolean)Config.CLIENT.sound.enableOcclusionCalcs.get() == false ? 1 : 0));
        this.occlusionToggle.m_93666_(this.generateTextForSetting(Config.CLIENT.sound.enableOcclusionCalcs));
    }

    protected Component generateTextForSetting(@Nonnull ForgeConfigSpec.BooleanValue value) {
        MutableComponent txt = OCCLUSION.m_6879_().m_130946_(": ");
        if (((Boolean)value.get()).booleanValue()) {
            txt.m_7220_(CommonComponents.f_130653_);
        } else {
            txt.m_7220_(CommonComponents.f_130654_);
        }
        return txt;
    }

    protected Component getSliderLabel(@Nonnull Component text) {
        return ((MutableComponent)text).m_7220_((Component)Component.m_237113_((String)": "));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (ForgeSlider slider : this.sliders) {
            if (!slider.m_5953_(mouseX, mouseY)) continue;
            slider.m_93611_(slider.getValue() + (double)(0.05f * (float)(delta > 0.0 ? 1 : -1)));
            break;
        }
        return false;
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return false;
    }

    public void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        QuickVolumeScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)FOOTER, (int)(this.f_96543_ / 2), (int)this.footerY, (int)ColorPalette.WHITE.rgb());
    }

    public void m_7379_() {
        for (int i = 0; i < this.categories.size(); ++i) {
            ISoundCategory cat = this.categories.get(i);
            try {
                cat.setVolumeScale(this.categoryValues.get(i).floatValue());
                continue;
            }
            catch (Throwable t) {
                SoundControl.LOGGER.error(t, "Error saving value for Sound Category %s", cat.getName());
            }
        }
        super.m_7379_();
    }
}

