/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.library;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public final class IndividualSoundConfig {
    private static final String BLOCK_TOKEN = "block";
    private static final String CULL_TOKEN = "cull";
    private static final String DELIMITER = " ";
    public static final int DEFAULT_VOLUME_SCALE = 100;
    public static final int VOLUME_SCALE_MIN = 0;
    public static final int VOLUME_SCALE_MAX = 400;
    private final ResourceLocation location;
    private boolean isBocked;
    private boolean isCulled;
    private int volumeScale;

    public IndividualSoundConfig(@Nonnull SoundEvent soundEvent) {
        this.location = soundEvent.m_11660_();
        this.isBocked = false;
        this.isCulled = false;
        this.volumeScale = 100;
    }

    public IndividualSoundConfig(@Nonnull IndividualSoundConfig source) {
        this.location = source.location;
        this.isBocked = source.isBocked;
        this.isCulled = source.isCulled;
        this.volumeScale = source.volumeScale;
    }

    public static boolean isValid(@Nonnull String text) {
        return IndividualSoundConfig.createFrom(text) != null;
    }

    private static boolean isResourceNameValid(@Nonnull String text) {
        if (!text.contains(":")) {
            return false;
        }
        ResourceLocation loc = ResourceLocation.m_135820_((String)text);
        if (loc == null) {
            return false;
        }
        return loc.m_135815_().length() > 0;
    }

    @Nullable
    public static IndividualSoundConfig createFrom(@Nonnull String entry) {
        ResourceLocation res;
        Optional<SoundEvent> event;
        IndividualSoundConfig result = null;
        String[] parts = entry.split(DELIMITER);
        if (parts.length == 0 || parts.length > 4) {
            return null;
        }
        if (IndividualSoundConfig.isResourceNameValid(parts[0]) && (event = SoundLibrary.getSound(res = new ResourceLocation(parts[0]))).isPresent()) {
            boolean isCulled = false;
            boolean isBlocked = false;
            int volumeControl = 100;
            for (int i = 1; i < parts.length; ++i) {
                if (CULL_TOKEN.compareToIgnoreCase(parts[i]) == 0) {
                    isCulled = true;
                    continue;
                }
                if (BLOCK_TOKEN.compareToIgnoreCase(parts[i]) == 0) {
                    isBlocked = true;
                    continue;
                }
                try {
                    volumeControl = Integer.parseInt(parts[i]);
                    continue;
                }
                catch (Throwable t) {
                    return null;
                }
            }
            result = new IndividualSoundConfig(event.get());
            result.isBocked = isBlocked;
            result.isCulled = isCulled;
            result.volumeScale = MathStuff.clamp(volumeControl, 0, 400);
        }
        return result;
    }

    @Nonnull
    public ResourceLocation getLocation() {
        return this.location;
    }

    public boolean isDefault() {
        return !this.isBocked && !this.isCulled && this.volumeScale == 100;
    }

    public boolean isBlocked() {
        return this.isBocked;
    }

    public void setIsBlocked(boolean flag) {
        this.isBocked = flag;
    }

    public boolean isCulled() {
        return this.isCulled;
    }

    public void setIsCulled(boolean flag) {
        this.isCulled = flag;
    }

    public float getVolumeScale() {
        return (float)this.volumeScale / 100.0f;
    }

    public int getVolumeScaleInt() {
        return this.volumeScale;
    }

    public void setVolumeScaleInt(int scale) {
        this.volumeScale = MathStuff.clamp(scale, 0, 400);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.location.toString());
        if (this.isBocked) {
            builder.append(DELIMITER).append(BLOCK_TOKEN);
        }
        if (this.isCulled) {
            builder.append(DELIMITER).append(CULL_TOKEN);
        }
        if (this.volumeScale != 100) {
            builder.append(DELIMITER).append(this.volumeScale);
        }
        return builder.toString();
    }
}

