/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.mixins;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Library;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.AudioEngine;
import org.orecruncher.sndctrl.audio.SoundUtils;
import org.orecruncher.sndctrl.audio.handlers.SoundFXProcessor;
import org.orecruncher.sndctrl.audio.handlers.SoundVolumeEvaluator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SoundEngine.class})
public class MixinSoundEngine {
    @Final
    @Shadow
    private Library f_120220_;
    @Final
    @Shadow
    public Map<SoundInstance, ChannelAccess.ChannelHandle> f_120226_;
    @Final
    @Shadow
    private Options f_120218_;
    @Final
    @Shadow
    private Map<SoundInstance, Integer> f_120230_;
    @Final
    @Shadow
    private Multimap<SoundSource, SoundInstance> f_120227_;
    @Final
    @Shadow
    private List<TickableSoundInstance> f_120228_;

    @Inject(method={"calculateVolume"}, at={@At(value="HEAD")}, cancellable=true)
    private void getClampedVolume(SoundInstance sound, CallbackInfoReturnable<Float> ci) {
        try {
            ci.setReturnValue((Object)Float.valueOf(SoundVolumeEvaluator.getClampedVolume(sound)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"loadLibrary"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/audio/Library;init(Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    public void initialize(CallbackInfo ci) {
        SoundUtils.initialize(this.f_120220_);
    }

    @Inject(method={"destroy"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/audio/Library;cleanup()V", shift=At.Shift.BEFORE)})
    public void deinitialize(CallbackInfo ci) {
        SoundUtils.deinitialize(this.f_120220_);
    }

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/ChannelAccess$ChannelHandle;execute(Ljava/util/function/Consumer;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    public void onSoundPlay(SoundInstance p_sound, CallbackInfo ci, WeighedSoundEvents soundeventaccessor, ResourceLocation resourcelocation, Sound sound, float f, float f1, SoundSource soundcategory, float f2, float f3, SoundInstance.Attenuation attenuationtype, boolean flag, Vec3 vector3d, boolean flag2, boolean flag3, CompletableFuture completablefuture, ChannelAccess.ChannelHandle entry) {
        try {
            SoundFXProcessor.onSoundPlay(p_sound, entry);
            AudioEngine.onPlaySound(p_sound);
        }
        catch (Throwable t) {
            SoundControl.LOGGER.error(t, "Error in onSoundPlay()!", new Object[0]);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(boolean isGamePaused, @Nonnull CallbackInfo ci) {
        if (!isGamePaused) {
            return;
        }
        Iterator<Map.Entry<SoundInstance, ChannelAccess.ChannelHandle>> iterator = this.f_120226_.entrySet().iterator();
        while (iterator.hasNext()) {
            ISoundInstance instance;
            Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry = iterator.next();
            if (!(entry.getKey() instanceof ISoundInstance) || (instance = (ISoundInstance)entry.getKey()).getSoundCategory() != Category.CONFIG) continue;
            ChannelAccess.ChannelHandle channelmanager$entry1 = entry.getValue();
            float f2 = this.f_120218_.m_92147_(instance.m_8070_());
            if (f2 <= 0.0f) {
                channelmanager$entry1.m_120154_(Channel::m_83679_);
                iterator.remove();
                continue;
            }
            if (!channelmanager$entry1.m_120151_()) continue;
            iterator.remove();
            this.f_120230_.remove(instance);
            try {
                this.f_120227_.remove((Object)instance.m_8070_(), (Object)instance);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!(instance instanceof TickableSoundInstance)) continue;
            this.f_120228_.remove(instance);
        }
    }
}

